/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.recipes;

import com.mojang.datafixers.util.Either;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public record OutputStack(Either<ItemStack, FluidStack> stack) {
    public static final OutputStack EMPTY = OutputStack.of(ItemStack.f_41583_);
    private static final String KEY_ITEM = "Item";
    private static final String KEY_FLUID = "Fluid";

    public static OutputStack of(ItemStack itemStack) {
        return new OutputStack((Either<ItemStack, FluidStack>)Either.left((Object)itemStack));
    }

    public static OutputStack of(FluidStack fluidStack) {
        return new OutputStack((Either<ItemStack, FluidStack>)Either.right((Object)fluidStack));
    }

    public ItemStack getItem() {
        return this.stack.left().orElse(ItemStack.f_41583_);
    }

    public FluidStack getFluid() {
        return this.stack.right().orElse(FluidStack.EMPTY);
    }

    public boolean isItem() {
        return this.stack.left().isPresent();
    }

    public boolean isFluid() {
        return this.stack.right().isPresent();
    }

    public boolean isEmpty() {
        if (this.isItem()) {
            return ((ItemStack)this.stack.left().get()).m_41619_();
        }
        if (this.isFluid()) {
            return ((FluidStack)this.stack.right().get()).isEmpty();
        }
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.isItem()) {
            tag.m_128365_(KEY_ITEM, (Tag)((ItemStack)this.stack.left().get()).serializeNBT());
        } else if (this.isFluid()) {
            tag.m_128365_(KEY_FLUID, (Tag)((FluidStack)this.stack.right().get()).writeToNBT(new CompoundTag()));
        }
        return tag;
    }

    public static OutputStack fromNBT(CompoundTag tag) {
        if (tag.m_128441_(KEY_ITEM)) {
            return OutputStack.of(ItemStack.m_41712_((CompoundTag)tag.m_128469_(KEY_ITEM)));
        }
        if (tag.m_128441_(KEY_FLUID)) {
            return OutputStack.fromNBT(tag.m_128469_(KEY_FLUID));
        }
        return EMPTY;
    }
}

