/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.api.capability.StoredEntityData;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.FixedScalable;
import com.enderio.api.capacitor.ICapacitorData;
import com.enderio.api.capacitor.LinearScalable;
import com.enderio.api.capacitor.QuadraticScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.core.common.network.slot.FluidStackNetworkDataSlot;
import com.enderio.core.common.network.slot.ResourceLocationNetworkDataSlot;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.PoweredSpawnerBlockEntity;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.MachineTankLayout;
import com.enderio.machines.common.io.fluid.TankAccess;
import com.enderio.machines.common.io.item.MachineInventoryLayout;
import com.enderio.machines.common.menu.SoulEngineMenu;
import com.enderio.machines.common.souldata.EngineSoul;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class SoulEngineBlockEntity
extends PoweredMachineBlockEntity {
    private static final QuadraticScalable CAPACITY = new QuadraticScalable(CapacitorModifier.ENERGY_CAPACITY, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SOUL_ENGINE_CAPACITY);
    public static final LinearScalable BURN_SPEED = new LinearScalable(CapacitorModifier.FIXED, (Supplier<Integer>)MachinesConfig.COMMON.ENERGY.SOUL_ENGINE_BURN_SPEED);
    public static final LinearScalable GENERATION_SPEED = new LinearScalable(CapacitorModifier.FIXED, () -> 1);
    private static final String BURNED_TICKS = "BurnedTicks";
    private StoredEntityData entityData = StoredEntityData.empty();
    public static final int FLUID_CAPACITY = 2000;
    private static final TankAccess TANK = new TankAccess();
    @Nullable
    private EngineSoul.SoulData soulData;
    private int burnedTicks = 0;
    private static boolean reload = false;
    private boolean reloadCache = !reload;

    public SoulEngineBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(EnergyIOMode.Output, CAPACITY, FixedScalable.ZERO, type, worldPosition, blockState);
        this.addDataSlot(new ResourceLocationNetworkDataSlot(() -> this.getEntityType().orElse(PoweredSpawnerBlockEntity.NO_MOB), this::setEntityType));
        this.addDataSlot(new FluidStackNetworkDataSlot(() -> TANK.getFluid(this), f -> TANK.setFluid(this, (FluidStack)f)));
    }

    @Override
    public MachineInventoryLayout createInventoryLayout() {
        return MachineInventoryLayout.builder().capacitor().build();
    }

    @Override
    @Nullable
    public MachineTankLayout getTankLayout() {
        return MachineTankLayout.builder().tank(TANK, 2000, this.isFluidValid()).build();
    }

    @Override
    public void serverTick() {
        if (this.reloadCache != reload && this.entityData != StoredEntityData.empty() && this.entityData.getEntityType().isPresent()) {
            Optional<EngineSoul.SoulData> op = EngineSoul.ENGINE.matches(this.entityData.getEntityType().get());
            op.ifPresent(data -> {
                this.soulData = data;
            });
            this.reloadCache = reload;
        }
        if (this.soulData != null && this.isActive()) {
            this.producePower();
        }
        this.updateMachineState(MachineState.NOT_SOULBOUND, this.soulData == null || this.entityData.getEntityType().isEmpty());
        super.serverTick();
    }

    public Optional<ResourceLocation> getEntityType() {
        return this.entityData.getEntityType();
    }

    public void setEntityType(ResourceLocation entityType) {
        this.entityData = StoredEntityData.of(entityType);
    }

    @Override
    protected boolean isActive() {
        return this.canAct() && TANK.getFluidAmount(this) > 0;
    }

    public void producePower() {
        if (this.burnedTicks >= this.soulData.tickpermb()) {
            int energy = (int)((float)this.soulData.powerpermb() * this.getGenerationRate());
            if (!TANK.getFluid(this).isEmpty() && this.getEnergyStorage().addEnergy(energy, true) == energy) {
                TANK.drain((MachineBlockEntity)this, 1, IFluidHandler.FluidAction.EXECUTE);
                this.getEnergyStorage().addEnergy(energy);
                this.burnedTicks -= this.soulData.tickpermb();
            }
        } else {
            this.burnedTicks += this.getBurnRate();
        }
    }

    public int getBurnRate() {
        return BURN_SPEED.scaleI((NonNullSupplier<ICapacitorData>)((NonNullSupplier)this::getCapacitorData)).get();
    }

    public float getGenerationRate() {
        return ((Integer)MachinesConfig.COMMON.ENERGY.SOUL_ENGINE_BURN_SPEED.get()).intValue();
    }

    @Override
    @Nullable
    protected MachineFluidHandler createFluidHandler(MachineTankLayout layout) {
        return new MachineFluidHandler(this.getIOConfig(), this.getTankLayout()){

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SoulEngineBlockEntity.this.updateMachineState(MachineState.EMPTY_TANK, TANK.getFluidAmount(this) <= 0);
                SoulEngineBlockEntity.this.m_6596_();
            }

            @Override
            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (TANK.isFluidValid(this, resource)) {
                    Fluid currentFluid = TANK.getFluid(this).getFluid();
                    if (currentFluid == Fluids.f_76191_ || resource.getFluid().m_6212_(currentFluid)) {
                        return super.fill(resource, action);
                    }
                    return super.fill(new FluidStack(currentFluid, resource.getAmount()), action);
                }
                return 0;
            }
        };
    }

    private Predicate<FluidStack> isFluidValid() {
        return fluidStack -> {
            if (this.soulData == null) {
                return false;
            }
            String fluid = this.soulData.fluid();
            if (fluid.startsWith("#")) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(fluid.substring(1)));
                Optional optional = ForgeRegistries.FLUIDS.tags().getTag(tag).stream().findFirst();
                if (optional.isPresent()) {
                    return fluidStack.getFluid().m_6212_((Fluid)optional.get());
                }
            } else {
                Optional delegate = ForgeRegistries.FLUIDS.getDelegate(new ResourceLocation(fluid));
                if (delegate.isPresent()) {
                    return fluidStack.getFluid().m_6212_((Fluid)((Holder.Reference)delegate.get()).get());
                }
            }
            return false;
        };
    }

    public MachineFluidTank getFluidTank() {
        return TANK.getTank(this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new SoulEngineMenu(this, playerInventory, containerId);
    }

    @Override
    protected MachineEnergyStorage createEnergyStorage(EnergyIOMode energyIOMode, Supplier<Integer> capacity, Supplier<Integer> usageRate) {
        return new MachineEnergyStorage(this.getIOConfig(), energyIOMode, capacity, usageRate){

            @Override
            protected void onContentsChanged() {
                SoulEngineBlockEntity.this.m_6596_();
                SoulEngineBlockEntity.this.updateMachineState(MachineState.FULL_POWER, SoulEngineBlockEntity.this.getEnergyStorage().getEnergyStored() >= SoulEngineBlockEntity.this.getEnergyStorage().getMaxEnergyStored() && SoulEngineBlockEntity.this.isCapacitorInstalled());
            }
        };
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_(BURNED_TICKS, this.burnedTicks);
        pTag.m_128365_("EntityStorage", this.entityData.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.burnedTicks = pTag.m_128451_(BURNED_TICKS);
        this.entityData.deserializeNBT((Tag)pTag.m_128469_("EntityStorage"));
        this.updateMachineState(MachineState.NO_POWER, false);
        this.updateMachineState(MachineState.FULL_POWER, this.getEnergyStorage().getEnergyStored() >= this.getEnergyStorage().getMaxEnergyStored() && this.isCapacitorInstalled());
    }

    @Override
    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateMachineState(MachineState.NO_POWER, false);
        this.updateMachineState(MachineState.FULL_POWER, this.getEnergyStorage().getEnergyStored() >= this.getEnergyStorage().getMaxEnergyStored() && this.isCapacitorInstalled());
    }

    @SubscribeEvent
    static void onReload(RecipesUpdatedEvent event) {
        reload = !reload;
    }
}

