/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.sync;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import com.enderio.machines.common.io.energy.ImmutableMachineEnergyStorage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class MachineEnergyNetworkDataSlot
extends NetworkDataSlot<IMachineEnergyStorage> {
    public MachineEnergyNetworkDataSlot(Supplier<IMachineEnergyStorage> getter, Consumer<IMachineEnergyStorage> setter) {
        super(getter, setter);
    }

    @Override
    public Tag serializeValueNBT(IMachineEnergyStorage value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("EnergyStored", value.getEnergyStored());
        tag.m_128405_("MaxEnergyStored", value.getMaxEnergyStored());
        tag.m_128405_("MaxEnergyUse", value.getMaxEnergyUse());
        return tag;
    }

    @Override
    protected IMachineEnergyStorage valueFromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbt;
            int energy = compoundTag.m_128451_("EnergyStored");
            int maxStored = compoundTag.m_128451_("MaxEnergyStored");
            int maxUse = compoundTag.m_128451_("MaxEnergyUse");
            return new ImmutableMachineEnergyStorage(energy, maxStored, maxUse);
        }
        throw new IllegalStateException("Invalid IMachineEnergyStorage tag was passed over the network.");
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, IMachineEnergyStorage value) {
        buf.writeInt(value.getEnergyStored());
        buf.writeInt(value.getMaxEnergyStored());
        buf.writeInt(value.getMaxEnergyUse());
    }

    @Override
    public IMachineEnergyStorage valueFromBuffer(FriendlyByteBuf buf) {
        try {
            int energy = buf.readInt();
            int maxStored = buf.readInt();
            int maxUse = buf.readInt();
            return new ImmutableMachineEnergyStorage(energy, maxStored, maxUse);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid IMachineEnergyStorage buffer was passed over the network.");
        }
    }

    @Override
    protected int hashCode(IMachineEnergyStorage value) {
        int code = 1;
        code = 31 * code + value.getEnergyStored();
        code = 31 * code + value.getMaxEnergyStored();
        return code;
    }
}

