/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.api.capability.StoredEntityData;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIOItems;
import com.enderio.machines.client.gui.screen.SoulEngineScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.souldata.EngineSoul;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SoulEngineCategory
implements IRecipeCategory<EngineSoul.SoulData> {
    public static final RecipeType<EngineSoul.SoulData> TYPE = RecipeType.create((String)"enderio", (String)"soul_engine", EngineSoul.SoulData.class);
    private final IDrawableStatic background;
    private final IDrawable icon;

    public SoulEngineCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(SoulEngineScreen.BG_TEXTURE, 49, 18, 124, 53);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.SOUL_ENGINE.get()));
    }

    public RecipeType<EngineSoul.SoulData> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_SOUL_ENGINE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EngineSoul.SoulData recipe, IFocusGroup focuses) {
        ArrayList list = new ArrayList();
        String fluid = recipe.fluid();
        if (fluid.startsWith("#")) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(fluid.substring(1)));
            ForgeRegistries.FLUIDS.tags().getTag(tag).stream().forEach(f -> list.add(new FluidStack(f, 2000)));
        } else {
            Optional delegate = ForgeRegistries.FLUIDS.getDelegate(new ResourceLocation(fluid));
            delegate.ifPresent(fluidReference -> list.add(new FluidStack((Fluid)fluidReference.get(), 2000)));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 31, 3).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, list)).setFluidRenderer(2000L, false, 16, 47);
        EntityType value = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(recipe.entitytype());
        if (recipe.getKey().equals((Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)value))) {
            if (ForgeSpawnEggItem.fromEntityType((EntityType)value) != null) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType((EntityType)value)));
            }
            ItemStack stack = new ItemStack(EIOItems.FILLED_SOUL_VIAL);
            stack.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(c -> c.setStoredEntityData(StoredEntityData.of(recipe.entitytype())));
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(stack);
        }
    }

    public void draw(EngineSoul.SoulData recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        EntityType value = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(recipe.entitytype());
        if (recipe.getKey().equals((Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)value))) {
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, value.m_20676_().getString(), 50, 5, 0x404040, false);
        }
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, recipe.tickpermb() + " t/mb", 50, 30, 0x404040, false);
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, recipe.powerpermb() + " \u00b5I/mb", 50, 40, 0x404040, false);
    }
}

