/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;

public abstract class MountedStorageSettingsContainerMenuBase
extends SettingsContainerMenu<IStorageWrapper> {
    private final int contraptionEntityId;
    private final BlockPos localPos;
    private CompoundTag lastSettingsNbt = null;

    public MountedStorageSettingsContainerMenuBase(MenuType<?> menuType, int windowId, Player player, IStorageWrapper storageWrapper, int contraptionEntityId, BlockPos localPos) {
        super(menuType, windowId, player, storageWrapper);
        this.contraptionEntityId = contraptionEntityId;
        this.localPos = localPos;
    }

    @Override
    public void detectSettingsChangeAndReload() {
        if (this.player.m_9236_().f_46443_) {
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> this.updateFromContents((UUID)uuid));
        }
    }

    protected abstract void updateFromContents(UUID var1);

    protected abstract CompoundTag getSettingsTag(CompoundTag var1);

    public int getContraptionEntityId() {
        return this.contraptionEntityId;
    }

    private void sendStorageSettingsToClient() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().m_6426_();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = this.storageWrapper.getSettingsHandler().getNbt();
                if (!settingsNbt.m_128456_()) {
                    settingsContents.m_128365_("settings", (Tag)settingsNbt);
                    Player patt1958$temp = this.player;
                    if (patt1958$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt1958$temp;
                        this.sendSettingsToClient((UUID)uuid, serverPlayer, settingsContents);
                    }
                }
            });
        }
    }

    protected abstract void sendSettingsToClient(UUID var1, ServerPlayer var2, CompoundTag var3);

    @Override
    public void m_38946_() {
        super.m_38946_();
        this.sendStorageSettingsToClient();
    }

    public BlockPos getLocalPos() {
        return this.localPos;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.localPos;
    }
}

