/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.filter;

import com.buuz135.industrial.proxy.block.filter.IFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class RegulatorFilter<TYPE, CAP> {
    private final int sizeX;
    private final int sizeY;
    private final int locX;
    private final int locY;
    private final int smallMultiplier;
    private final int bigMultiplier;
    private final int maxAmount;
    private final String label;
    private IFilter.GhostSlot[] filter;

    public RegulatorFilter(int locX, int locY, int sizeX, int sizeY, int smallMultiplier, int bigMultiplier, int maxAmount, String label) {
        this.locX = locX;
        this.locY = locY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.smallMultiplier = smallMultiplier;
        this.bigMultiplier = bigMultiplier;
        this.maxAmount = maxAmount;
        this.label = label;
        this.filter = new IFilter.GhostSlot[sizeX * sizeY];
        int pos = 0;
        for (int y = 0; y < sizeY; ++y) {
            for (int x = 0; x < sizeX; ++x) {
                this.filter[pos] = new IFilter.GhostSlot(pos, locX + x * 18, locY + y * 18);
                this.filter[pos].setMaxAmount(this.maxAmount);
                ++pos;
            }
        }
    }

    public abstract int matches(TYPE var1, CAP var2, boolean var3);

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getLocX() {
        return this.locX;
    }

    public int getLocY() {
        return this.locY;
    }

    public IFilter.GhostSlot[] getFilter() {
        return this.filter;
    }

    public void setFilter(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.getFilter().length) {
            this.getFilter()[slot].setStack(stack);
            this.getFilter()[slot].setAmount(stack.m_41613_());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        for (int i = 0; i < this.getFilter().length; ++i) {
            if (this.getFilter()[i].getStack().m_41619_()) continue;
            CompoundTag slot = new CompoundTag();
            slot.m_128365_("Stack", (Tag)this.getFilter()[i].getStack().serializeNBT());
            slot.m_128405_("Amount", this.getFilter()[i].getAmount());
            compound.m_128365_(String.valueOf(i), (Tag)slot);
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (int i = 0; i < this.getFilter().length; ++i) {
            if (nbt.m_128441_(String.valueOf(i))) {
                CompoundTag slot = nbt.m_128469_(String.valueOf(i));
                this.getFilter()[i].setStack(ItemStack.m_41712_((CompoundTag)slot.m_128469_("Stack")));
                this.getFilter()[i].setAmount(slot.m_128451_("Amount"));
                continue;
            }
            this.getFilter()[i].setStack(ItemStack.f_41583_);
        }
    }

    public boolean isEmpty() {
        for (IFilter.GhostSlot slot : this.getFilter()) {
            if (slot.getStack().m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int getSmallMultiplier() {
        return this.smallMultiplier;
    }

    public int getBigMultiplier() {
        return this.bigMultiplier;
    }

    public String getLabel() {
        return this.label;
    }
}

