/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Counter;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbuilder.modules.builder.BlockInformation;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.modules.builder.network.PacketChamberInfoReady;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BuilderTools {
    public static void returnChamberInfo(Player player) {
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = BuilderTools.getSpaceChamberChannel(player);
        if (chamberChannel == null) {
            return;
        }
        ServerLevel world = LevelTools.getLevel((Level)player.m_20193_(), chamberChannel.getDimension());
        if (world == null) {
            return;
        }
        Counter blocks = new Counter();
        Counter costs = new Counter();
        HashMap<BlockState, ItemStack> stacks = new HashMap<BlockState, ItemStack>();
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        BuilderTools.findBlocks(player, (Level)world, (Counter<BlockState>)blocks, (Counter<BlockState>)costs, stacks, minCorner, maxCorner);
        Counter entitiesWithCount = new Counter();
        Counter entitiesWithCost = new Counter();
        HashMap<String, Entity> firstEntity = new HashMap<String, Entity>();
        BuilderTools.findEntities((Level)world, minCorner, maxCorner, (Counter<String>)entitiesWithCount, (Counter<String>)entitiesWithCost, firstEntity);
        RFToolsBuilderMessages.sendToPlayer(PacketChamberInfoReady.create((Map<BlockState, Integer>)blocks, (Map<BlockState, Integer>)costs, stacks, (Map<String, Integer>)entitiesWithCount, (Map<String, Integer>)entitiesWithCost, firstEntity), player);
    }

    @Nullable
    public static SpaceChamberRepository.SpaceChamberChannel getSpaceChamberChannel(Player player) {
        ItemStack cardItem = player.m_21120_(InteractionHand.MAIN_HAND);
        return BuilderTools.getSpaceChamberChannel(player.m_20193_(), cardItem);
    }

    @Nullable
    public static SpaceChamberRepository.SpaceChamberChannel getSpaceChamberChannel(Level level, ItemStack cardItem) {
        Integer channel = BuilderTools.getChannel(cardItem);
        if (channel == null) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.get(level);
        return repository.getChannel(channel);
    }

    @Nullable
    public static Integer getChannel(ItemStack cardItem) {
        if (cardItem.m_41619_() || cardItem.m_41783_() == null) {
            return null;
        }
        int channel = cardItem.m_41783_().m_128451_("channel");
        if (channel == -1) {
            return null;
        }
        return channel;
    }

    private static void findEntities(Level world, BlockPos minCorner, BlockPos maxCorner, Counter<String> entitiesWithCount, Counter<String> entitiesWithCost, Map<String, Entity> firstEntity) {
        List entities = world.m_45933_(null, new AABB((double)minCorner.m_123341_(), (double)minCorner.m_123342_(), (double)minCorner.m_123343_(), (double)(maxCorner.m_123341_() + 1), (double)(maxCorner.m_123342_() + 1), (double)(maxCorner.m_123343_() + 1)));
        for (Entity entity : entities) {
            ItemEntity entityItem;
            Object canonicalName = entity.getClass().getCanonicalName();
            if (entity instanceof ItemEntity && !(entityItem = (ItemEntity)entity).m_32055_().m_41619_()) {
                String displayName = entityItem.m_32055_().m_41786_().getString();
                canonicalName = (String)canonicalName + " (" + displayName + ")";
            }
            entitiesWithCount.increment(canonicalName);
            if (!firstEntity.containsKey(canonicalName)) {
                firstEntity.put((String)canonicalName, entity);
            }
            if (entity instanceof Player) {
                entitiesWithCost.increment(canonicalName, ((Integer)BuilderConfiguration.builderRfPerPlayer.get()).intValue());
                continue;
            }
            entitiesWithCost.increment(canonicalName, ((Integer)BuilderConfiguration.builderRfPerEntity.get()).intValue());
        }
    }

    private static void findBlocks(Player harvester, Level world, Counter<BlockState> blocks, Counter<BlockState> costs, Map<BlockState, ItemStack> stacks, BlockPos minCorner, BlockPos maxCorner) {
        for (int x = minCorner.m_123341_(); x <= maxCorner.m_123341_(); ++x) {
            for (int y = minCorner.m_123342_(); y <= maxCorner.m_123342_(); ++y) {
                for (int z = minCorner.m_123343_(); z <= maxCorner.m_123343_(); ++z) {
                    BlockEntity te;
                    BlockInformation info;
                    ItemStack item;
                    Block block;
                    BlockPos p = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(p);
                    if (BuilderTileEntity.isEmpty(state, block = state.m_60734_())) continue;
                    blocks.increment((Object)state);
                    if (!stacks.containsKey(state) && !(item = block.m_7397_((BlockGetter)world, p, state)).m_41619_()) {
                        stacks.put(state, item);
                    }
                    if ((info = BuilderTileEntity.getBlockInformation(harvester, world, p, block, te = world.m_7702_(p))).getBlockLevel() == SupportBlock.SupportStatus.STATUS_ERROR) {
                        costs.put((Object)state, (Object)-1);
                        continue;
                    }
                    costs.increment((Object)state, (int)((double)((Integer)BuilderConfiguration.builderRfPerOperation.get()).intValue() * info.getCostFactor()));
                }
            }
        }
    }
}

