/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.DamageTools;
import mcjty.lib.varia.FakePlayerConnection;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.shield.DamageTypeMode;
import mcjty.rftoolsbuilder.modules.shield.RelCoordinateShield;
import mcjty.rftoolsbuilder.modules.shield.ShieldConfiguration;
import mcjty.rftoolsbuilder.modules.shield.ShieldModule;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldTemplateBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import mcjty.rftoolsbuilder.modules.shield.client.GuiShield;
import mcjty.rftoolsbuilder.modules.shield.client.ShieldRenderData;
import mcjty.rftoolsbuilder.modules.shield.filters.AbstractShieldFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import mcjty.rftoolsbuilder.modules.shield.network.PacketNotifyServerClientReady;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.Shape;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;

public class ShieldProjectorTileEntity
extends TickingTileEntity
implements ISmartWrenchSelector {
    public static final String COMPONENT_NAME = "shield_projector";
    @GuiValue
    public static final Value<?, Integer> VALUE_SHIELDVISMODE = Value.create((String)"shieldVisMode", (Type)Type.INTEGER, te -> te.getShieldRenderingMode().ordinal(), (te, v) -> te.setShieldRenderingMode(ShieldRenderingMode.values()[v]));
    @GuiValue
    public static final Value<?, Integer> VALUE_SHIELDTEXTURE = Value.create((String)"shieldTexture", (Type)Type.INTEGER, te -> te.getShieldTexture().ordinal(), (te, v) -> te.setShieldTexture(ShieldTexture.values()[v]));
    @GuiValue
    public static final Value<?, Integer> VALUE_DAMAGEMODE = Value.create((String)"damageMode", (Type)Type.INTEGER, te -> te.getDamageMode().ordinal(), (te, v) -> te.setDamageMode(DamageTypeMode.values()[v]));
    @GuiValue
    public static final Value<?, Integer> VALUE_COLOR = Value.create((String)"color", (Type)Type.INTEGER, ShieldProjectorTileEntity::getShieldColor, ShieldProjectorTileEntity::setShieldColor);
    @GuiValue
    public static final Value<?, Boolean> VALUE_LIGHT = Value.create((String)"light", (Type)Type.BOOLEAN, ShieldProjectorTileEntity::isBlockLight, ShieldProjectorTileEntity::setBlockLight);
    private ShieldRenderData renderData;
    private DamageTypeMode damageMode = DamageTypeMode.DAMAGETYPE_GENERIC;
    private boolean shieldComposed = false;
    private BlockState templateState = Blocks.f_50016_.m_49966_();
    private boolean shieldActive = false;
    private int powerTimeout = 0;
    private int updateTimeout = 0;
    private int shieldColor;
    private boolean blockLight = false;
    private int supportedBlocks;
    private float damageFactor = 1.0f;
    private float costFactor = 1.0f;
    private final List<ShieldFilter> filters = new ArrayList<ShieldFilter>();
    private ShieldTexture shieldTexture = ShieldTexture.SHIELD;
    private ShieldRenderingMode shieldRenderingMode = ShieldRenderingMode.SHIELD;
    private final List<RelCoordinateShield> shieldBlocks = new ArrayList<RelCoordinateShield>();
    private final List<BlockState> blockStateTable = new ArrayList<BlockState>();
    private final FakePlayerGetter fakePlayer = new FakePlayerGetter((GenericTileEntity)this, "rftools_shield");
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_SHAPE = 1;
    public static final int SLOT_SHARD = 2;
    public static final int BUFFER_SIZE = 3;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.generic().in(), 0, 26, 142).slot(SlotDefinition.specific(s -> s.m_41720_() instanceof ShapeCardItem).in().out(), 1, 26, 200).slot(SlotDefinition.specific(s -> s.m_41720_() == VariousModule.DIMENSIONALSHARD.get()).in().out(), 2, 229, 118).playerSlots(85, 142));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 1) {
            return stack.m_41720_() instanceof ShapeCardItem;
        }
        if (slot == 2) {
            return stack.m_41720_() == VariousModule.DIMENSIONALSHARD.get();
        }
        return true;
    }).onUpdate((index, stack) -> {
        if (index == 1 && !stack.m_41619_()) {
            this.decomposeShield();
        }
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyHandler;
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Shield").containerSupplier(DefaultContainerProvider.container(ShieldModule.CONTAINER_SHIELD, CONTAINER_FACTORY, (GenericTileEntity)this)).energyHandler(this::getEnergyStorage).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusableHandler = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.POWER_INFO)
    private final IPowerInformation powerInfoHandler = this.createPowerInfo();
    private final int maxEnergy;
    private final int rfPerTick;
    private ItemStack lootingSword = ItemStack.f_41583_;
    public static final Key<Integer> PARAM_ACTION = new Key("action", Type.INTEGER);
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<Integer> PARAM_SELECTED = new Key("selected", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_ADDFILTER = Command.create((String)"shield.addFilter", (te, player, params) -> te.addFilter((Integer)params.get(PARAM_ACTION), (String)params.get(PARAM_TYPE), (String)params.get(PARAM_PLAYER), (Integer)params.get(PARAM_SELECTED)));
    @ServerCommand
    public static final Command<?> CMD_DELFILTER = Command.create((String)"shield.delFilter", (te, player, params) -> te.delFilter((Integer)params.get(PARAM_SELECTED)));
    @ServerCommand
    public static final Command<?> CMD_UPFILTER = Command.create((String)"shield.upFilter", (te, player, params) -> te.upFilter((Integer)params.get(PARAM_SELECTED)));
    @ServerCommand
    public static final Command<?> CMD_DOWNFILTER = Command.create((String)"shield.downFilter", (te, player, params) -> te.downFilter((Integer)params.get(PARAM_SELECTED)));
    @ServerCommand(type=ShieldFilter.class, serializer=ShieldFilter.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETFILTERS = ListCommand.create((String)"rftoolsbuilder.shield.getFilters", (te, player, params) -> te.getFilters(), (te, player, params, list) -> GuiShield.storeFiltersForClient(list));

    public ShieldProjectorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int supportedBlocks, int maxEnergy, int rfPerTick) {
        super(type, pos, state);
        this.supportedBlocks = supportedBlocks;
        this.maxEnergy = maxEnergy;
        this.rfPerTick = rfPerTick;
        this.energyHandler = new GenericEnergyStorage((GenericTileEntity)this, true, (long)this.getConfigMaxEnergy(), (long)this.getConfigRfPerTick());
    }

    @Nonnull
    public GenericEnergyStorage getEnergyStorage() {
        return this.energyHandler;
    }

    private int getConfigMaxEnergy() {
        return this.maxEnergy;
    }

    private int getConfigRfPerTick() {
        return this.rfPerTick;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public ShieldProjectorTileEntity setDamageFactor(float factor) {
        this.damageFactor = factor;
        return this;
    }

    public ShieldProjectorTileEntity setCostFactor(float factor) {
        this.costFactor = factor;
        return this;
    }

    public ShieldRenderData getRenderData() {
        if (this.renderData == null) {
            float r = (float)(this.shieldColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.shieldColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.shieldColor & 0xFF) / 255.0f;
            this.renderData = new ShieldRenderData(r, g, b, 1.0f, this.shieldTexture);
        }
        return this.renderData;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        int oldColor = this.shieldColor;
        ShieldTexture oldTexture = this.shieldTexture;
        super.onDataPacket(net, packet);
        if (oldColor != this.shieldColor || oldTexture != this.shieldTexture) {
            this.renderData = null;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    public List<ShieldFilter> getFilters() {
        return this.filters;
    }

    public boolean isBlockLight() {
        return this.blockLight;
    }

    public void setBlockLight(boolean blockLight) {
        this.blockLight = blockLight;
        this.updateTimeout = 10;
        this.m_6596_();
    }

    public int getShieldColor() {
        return this.shieldColor;
    }

    public void setShieldColor(int shieldColor) {
        this.shieldColor = shieldColor;
        this.updateTimeout = 10;
        this.m_6596_();
    }

    private void delFilter(int selected) {
        this.filters.remove(selected);
        this.updateTimeout = 10;
        this.m_6596_();
    }

    private void upFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected - 1);
        ShieldFilter filter2 = this.filters.get(selected);
        this.filters.set(selected - 1, filter2);
        this.filters.set(selected, filter1);
        this.m_6596_();
    }

    private void downFilter(int selected) {
        ShieldFilter filter1 = this.filters.get(selected);
        ShieldFilter filter2 = this.filters.get(selected + 1);
        this.filters.set(selected, filter2);
        this.filters.set(selected + 1, filter1);
        this.m_6596_();
    }

    private void addFilter(int action, String type, String player, int selected) {
        ShieldFilter filter = AbstractShieldFilter.createFilter(type);
        filter.setAction(action);
        if (filter instanceof PlayerFilter) {
            ((PlayerFilter)filter).setName(player);
        }
        if (selected == -1) {
            this.filters.add(filter);
        } else {
            this.filters.add(selected, filter);
        }
        this.updateTimeout = 10;
        this.m_6596_();
    }

    public DamageTypeMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(DamageTypeMode damageMode) {
        this.damageMode = damageMode;
        this.m_6596_();
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return this.shieldRenderingMode;
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        this.shieldRenderingMode = shieldRenderingMode;
        this.updateTimeout = 10;
        this.m_6596_();
    }

    public ShieldTexture getShieldTexture() {
        return this.shieldTexture;
    }

    public void setShieldTexture(ShieldTexture shieldTexture) {
        this.shieldTexture = shieldTexture;
        this.updateTimeout = 10;
        this.m_6596_();
    }

    @Nonnull
    private BlockState getStateFromItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ServerPlayer player = this.fakePlayer.get();
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
            BlockHitResult result = new BlockHitResult(new Vec3(0.5, 0.0, 0.5), Direction.UP, this.f_58858_, false);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, result));
            BlockState stateForPlacement = blockItem.m_40614_().m_5573_(context);
            return stateForPlacement == null ? blockItem.m_40614_().m_49966_() : stateForPlacement;
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Nullable
    private BlockState calculateMimic() {
        if (!ShieldRenderingMode.MIMIC.equals((Object)this.shieldRenderingMode)) {
            return null;
        }
        Optional<BlockState> map = this.getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h.getStackInSlot(0)).filter(stack -> !stack.m_41619_()).map(this::getStateFromItem);
        if (map.isPresent()) {
            return map.orElseThrow(RuntimeException::new);
        }
        return null;
    }

    private BlockState calculateShieldBlock(BlockState mimic, boolean blockLight) {
        if (!this.shieldActive || this.powerTimeout > 0) {
            return Blocks.f_50016_.m_49966_();
        }
        ShieldRenderingMode render = this.shieldRenderingMode;
        if (!((Boolean)ShieldConfiguration.allowInvisibleShield.get()).booleanValue() && ShieldRenderingMode.INVISIBLE.equals((Object)this.shieldRenderingMode)) {
            render = ShieldRenderingMode.SOLID;
        }
        if (mimic != null) {
            render = ShieldRenderingMode.MIMIC;
        }
        BlockState shielding = this.getShieldingBlock(render, mimic).m_49966_();
        shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.FLAG_OPAQUE, (Comparable)Boolean.valueOf(!blockLight));
        shielding = (BlockState)shielding.m_61124_(ShieldingBlock.RENDER_MODE, (Comparable)((Object)render));
        shielding = this.calculateShieldCollisionData(shielding);
        shielding = this.calculateDamageBits(shielding);
        return shielding;
    }

    private Block getShieldingBlock(ShieldRenderingMode render, BlockState mimic) {
        if (mimic == null) {
            if (render.isTranslucent()) {
                return ShieldModule.SHIELDING_TRANSLUCENT.get();
            }
            return ShieldModule.SHIELDING_SOLID.get();
        }
        return ShieldModule.SHIELDING_SOLID.get();
    }

    private BlockState calculateDamageBits(BlockState shielding) {
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 2) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.DAMAGE_ITEMS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            shielding = (BlockState)((BlockState)((BlockState)((BlockState)shielding.m_61124_((Property)ShieldingBlock.DAMAGE_ITEMS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ShieldingBlock.DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ShieldingBlock.DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ShieldingBlock.DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(true));
        }
        return shielding;
    }

    private BlockState calculateShieldCollisionData(BlockState shielding) {
        for (ShieldFilter filter : this.filters) {
            if ((filter.getAction() & 1) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.BLOCKED_ITEMS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.m_61124_((Property)ShieldingBlock.BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            shielding = (BlockState)((BlockState)((BlockState)((BlockState)shielding.m_61124_((Property)ShieldingBlock.BLOCKED_ITEMS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ShieldingBlock.BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ShieldingBlock.BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ShieldingBlock.BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(true));
        }
        return shielding;
    }

    private int calculateRfPerTick() {
        if (!this.shieldActive) {
            return 0;
        }
        int s = this.shieldBlocks.size() - 50;
        if (s < 10) {
            s = 10;
        }
        int rf = (Integer)ShieldConfiguration.rfBase.get() * s / 10;
        if (ShieldRenderingMode.SHIELD.equals((Object)this.shieldRenderingMode)) {
            rf += (Integer)ShieldConfiguration.rfShield.get() * s / 10;
        } else if (ShieldRenderingMode.MIMIC.equals((Object)this.shieldRenderingMode)) {
            rf += (Integer)ShieldConfiguration.rfCamo.get() * s / 10;
        }
        return rf;
    }

    public boolean isShieldComposed() {
        return this.shieldComposed;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public void applyDamageToEntity(Entity entity) {
        DamageSource source;
        int rf;
        if (DamageTypeMode.DAMAGETYPE_GENERIC.equals((Object)this.damageMode)) {
            rf = (Integer)ShieldConfiguration.rfDamage.get();
            source = DamageTools.getGenericDamageSource((Entity)entity);
        } else {
            rf = (Integer)ShieldConfiguration.rfDamagePlayer.get();
            ServerPlayer killer = this.fakePlayer.get();
            killer.m_6034_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
            new FakePlayerConnection(this.f_58857_.m_7654_(), killer);
            ItemStack shards = this.items.getStackInSlot(2);
            if (!shards.m_41619_() && shards.m_41613_() >= (Integer)ShieldConfiguration.shardsPerLootingKill.get()) {
                this.items.extractItem(2, ((Integer)ShieldConfiguration.shardsPerLootingKill.get()).intValue(), false);
                if (this.lootingSword.m_41619_()) {
                    this.lootingSword = ShieldProjectorTileEntity.createEnchantedItem(Items.f_42388_, Enchantments.f_44982_, (Integer)ShieldConfiguration.lootingKillBonus.get());
                }
                this.lootingSword.m_41721_(0);
                killer.m_21008_(InteractionHand.MAIN_HAND, this.lootingSword);
            } else {
                killer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            source = DamageTools.getPlayerAttackDamageSource((Entity)killer, (Player)killer);
        }
        float factor = this.infusableHandler.getInfusedFactor();
        rf = (int)((float)rf * this.costFactor * (4.0f - factor) / 4.0f);
        if (this.energyHandler.getEnergyStored() < rf) {
            return;
        }
        this.energyHandler.consumeEnergy((long)rf);
        float damage = (float)((Double)ShieldConfiguration.damage.get()).doubleValue();
        damage *= this.damageFactor;
        entity.m_6469_(source, damage *= 1.0f + factor / 2.0f);
    }

    public static ItemStack createEnchantedItem(Item item, Enchantment effectId, int amount) {
        ItemStack stack = new ItemStack((ItemLike)item);
        HashMap<Enchantment, Integer> enchant = new HashMap<Enchantment, Integer>();
        enchant.put(effectId, amount);
        EnchantmentHelper.m_44865_(enchant, (ItemStack)stack);
        return stack;
    }

    protected void tickServer() {
        boolean newShieldActive;
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.shieldComposed) {
            return;
        }
        if (this.updateTimeout > 0) {
            --this.updateTimeout;
            if (this.updateTimeout <= 0) {
                this.updateShield();
            }
        }
        boolean checkPower = false;
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            this.m_6596_();
            if (this.powerTimeout > 0) {
                return;
            }
            checkPower = true;
        }
        boolean needsUpdate = false;
        int rf = this.getRfPerTick();
        if (rf > 0) {
            if (this.energyHandler.getEnergyStored() < rf) {
                this.powerTimeout = 100;
                needsUpdate = true;
            } else {
                if (checkPower) {
                    needsUpdate = true;
                }
                this.energyHandler.consumeEnergy((long)rf);
            }
        }
        if ((newShieldActive = this.isMachineEnabled()) != this.shieldActive) {
            needsUpdate = true;
            this.shieldActive = newShieldActive;
        }
        if (needsUpdate) {
            this.updateShield();
            this.markDirtyClient();
        }
    }

    public void clientIsReady() {
        this.updateShield();
    }

    private int getRfPerTick() {
        int rf = this.calculateRfPerTick();
        float factor = this.infusableHandler.getInfusedFactor();
        rf = (int)((float)rf * (2.0f - factor) / 2.0f);
        return rf;
    }

    public void composeDecomposeShield(boolean ctrl) {
        if (this.shieldComposed) {
            this.decomposeShield();
        } else {
            this.composeShield(ctrl);
        }
    }

    public void composeShield(boolean ctrl) {
        HashMap<BlockPos, BlockState> coordinates;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (this.isShapedShield()) {
            this.templateState = Blocks.f_50016_.m_49966_();
            ItemStack shapeItem = this.items.getStackInSlot(1);
            Shape shape = ShapeCardItem.getShape(shapeItem);
            boolean solid = ShapeCardItem.isSolid(shapeItem);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeItem, (int)((Integer)ShieldConfiguration.maxShieldDimension.get()));
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeItem, (int)((Integer)ShieldConfiguration.maxShieldOffset.get()));
            HashMap<BlockPos, BlockState> col = new HashMap<BlockPos, BlockState>();
            ShapeCardItem.composeFormula(shapeItem, shape.getFormulaFactory().get(), this.m_58904_(), this.m_58899_(), dimension, offset, col, this.supportedBlocks, solid, false, null);
            coordinates = col;
        } else {
            if (!this.findTemplateState()) {
                return;
            }
            HashMap<BlockPos, BlockState> col = new HashMap<BlockPos, BlockState>();
            this.findTemplateBlocks(col, this.templateState, ctrl, this.m_58899_());
            coordinates = col;
        }
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        for (Map.Entry entry : coordinates.entrySet()) {
            BlockPos c = (BlockPos)entry.getKey();
            BlockState state = (BlockState)entry.getValue();
            int st = -1;
            if (state != null) {
                for (int i = 0; i < this.blockStateTable.size(); ++i) {
                    if (!state.equals(this.blockStateTable.get(i))) continue;
                    st = i;
                    break;
                }
                if (st == -1) {
                    st = this.blockStateTable.size();
                    this.blockStateTable.add(state);
                }
            }
            this.shieldBlocks.add(new RelCoordinateShield(c.m_123341_() - xCoord, c.m_123342_() - yCoord, c.m_123343_() - zCoord, st));
            this.m_58904_().m_46597_(c, Blocks.f_50016_.m_49966_());
        }
        this.shieldComposed = true;
        this.updateShield();
    }

    private boolean isShapedShield() {
        return !this.items.getStackInSlot(1).m_41619_();
    }

    private boolean findTemplateState() {
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            BlockState state;
            BlockPos p = this.m_58899_().m_121945_(dir);
            if (p.m_123342_() < this.f_58857_.m_141937_() || p.m_123342_() >= this.f_58857_.m_151558_() || !((state = this.m_58904_().m_8055_(p)).m_60734_() instanceof ShieldTemplateBlock)) continue;
            this.templateState = state;
            return true;
        }
        return false;
    }

    public void selectBlock(Player player, BlockPos pos) {
        if (!this.shieldComposed) {
            Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Shield is not composed. Nothing happens!"));
            return;
        }
        float squaredDistance = (float)this.m_58899_().m_123331_((Vec3i)pos);
        if (squaredDistance > (float)((Integer)ShieldConfiguration.maxDisjointShieldDistance.get() * (Integer)ShieldConfiguration.maxDisjointShieldDistance.get())) {
            Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "This template is too far to connect to the shield!"));
            return;
        }
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        Block origBlock = this.m_58904_().m_8055_(pos).m_60734_();
        if (origBlock instanceof ShieldTemplateBlock) {
            if (this.isShapedShield()) {
                Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "You cannot add template blocks to a shaped shield (using a shape card)!"));
                return;
            }
            HashMap<BlockPos, BlockState> templateBlocks = new HashMap<BlockPos, BlockState>();
            BlockState state = this.m_58904_().m_8055_(pos);
            templateBlocks.put(pos, null);
            this.findTemplateBlocks(templateBlocks, state, false, pos);
            BlockState mimic = this.calculateMimic();
            BlockState shielding = this.calculateShieldBlock(mimic, this.blockLight);
            for (Map.Entry entry : templateBlocks.entrySet()) {
                BlockPos templateBlock = (BlockPos)entry.getKey();
                RelCoordinateShield relc = new RelCoordinateShield(templateBlock.m_123341_() - xCoord, templateBlock.m_123342_() - yCoord, templateBlock.m_123343_() - zCoord, -1);
                this.shieldBlocks.add(relc);
                this.updateShieldBlock(mimic, shielding, relc);
            }
        } else if (origBlock instanceof ShieldingBlock) {
            int dx = pos.m_123341_() - xCoord;
            int dy = pos.m_123342_() - yCoord;
            int dz = pos.m_123343_() - zCoord;
            int idx = IntStream.range(0, this.shieldBlocks.size()).filter(i -> this.shieldBlocks.get(i).matches(dx, dy, dz)).findFirst().orElse(-1);
            if (idx != -1) {
                this.shieldBlocks.remove(idx);
            }
            this.m_58904_().m_7731_(pos, this.templateState, 2);
        } else {
            Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "The selected shield can't do anything with this block!"));
            return;
        }
        this.m_6596_();
    }

    private void updateShield() {
        BlockState mimic = this.calculateMimic();
        BlockState shielding = this.calculateShieldBlock(mimic, this.blockLight);
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (RelCoordinateShield c : this.shieldBlocks) {
            if (Blocks.f_50016_.equals(shielding.m_60734_())) {
                pos.m_122178_(xCoord + c.dx(), yCoord + c.dy(), zCoord + c.dz());
                BlockState oldState = this.m_58904_().m_8055_((BlockPos)pos);
                if (!(oldState.m_60734_() instanceof ShieldingBlock)) continue;
                this.m_58904_().m_46597_((BlockPos)pos, Blocks.f_50016_.m_49966_());
                continue;
            }
            this.updateShieldBlock(mimic, shielding, c);
        }
        this.m_6596_();
    }

    private void updateShieldBlock(BlockState mimic, BlockState shielding, RelCoordinateShield c) {
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        BlockPos pp = new BlockPos(xCoord + c.dx(), yCoord + c.dy(), zCoord + c.dz());
        BlockState oldState = this.m_58904_().m_8055_(pp);
        if (!(oldState.m_60734_() instanceof ShieldingBlock || oldState.m_247087_() || oldState.m_60734_() instanceof ShieldTemplateBlock)) {
            return;
        }
        this.f_58857_.m_46597_(pp, Blocks.f_50016_.m_49966_());
        this.f_58857_.m_7731_(pp, shielding, 1);
        BlockEntity te = this.m_58904_().m_7702_(pp);
        if (te instanceof ShieldingTileEntity) {
            ShieldingTileEntity shieldingTE = (ShieldingTileEntity)te;
            if (c.state() != -1) {
                BlockState state = this.blockStateTable.get(c.state());
                shieldingTE.setMimic(state);
            } else {
                shieldingTE.setMimic(mimic);
            }
            shieldingTE.setShieldProjector(this.f_58858_);
        }
    }

    public void decomposeShield() {
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        BlockPos.MutableBlockPos pp = new BlockPos.MutableBlockPos();
        for (RelCoordinateShield c : this.shieldBlocks) {
            int cx = xCoord + c.dx();
            int cy = yCoord + c.dy();
            int cz = zCoord + c.dz();
            pp.m_122178_(cx, cy, cz);
            Block block = this.m_58904_().m_8055_((BlockPos)pp).m_60734_();
            if (this.m_58904_().m_46859_((BlockPos)pp) || block instanceof ShieldingBlock) {
                this.m_58904_().m_7731_(new BlockPos((Vec3i)pp), this.templateState, 2);
                continue;
            }
            if (this.templateState.m_60795_() || this.isShapedShield()) continue;
            Containers.m_18992_((Level)this.m_58904_(), (double)cx, (double)cy, (double)cz, (ItemStack)this.templateState.m_60734_().m_7397_((BlockGetter)this.m_58904_(), new BlockPos(cx, cy, cz), this.templateState));
        }
        this.shieldComposed = false;
        this.shieldActive = false;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        this.m_6596_();
    }

    private void findTemplateBlocks(Map<BlockPos, BlockState> coordinateSet, BlockState templateState, boolean ctrl, BlockPos start) {
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        if (ctrl) {
            this.addToTodoCornered(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoCornered(coordinateSet, todo, coordinate, templateState);
            }
        } else {
            this.addToTodoStraight(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoStraight(coordinateSet, todo, coordinate, templateState);
            }
        }
    }

    private void addToTodoStraight(Map<BlockPos, BlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, BlockState templateState) {
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            BlockState state;
            BlockPos pp = coordinate.m_121945_(dir);
            if (pp.m_123342_() < this.f_58857_.m_141937_() || pp.m_123342_() >= this.f_58857_.m_151558_() || coordinateSet.containsKey(pp) || (state = this.m_58904_().m_8055_(pp)) != templateState || todo.contains(pp)) continue;
            todo.addLast(pp);
        }
    }

    private void addToTodoCornered(Map<BlockPos, BlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, BlockState templateState) {
        int x = coordinate.m_123341_();
        int y = coordinate.m_123342_();
        int z = coordinate.m_123343_();
        BlockPos.MutableBlockPos c = new BlockPos.MutableBlockPos();
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int zz = z - 1; zz <= z + 1; ++zz) {
                    BlockState state;
                    if (xx == x && yy == y && zz == z || yy < this.m_58904_().m_141937_() || yy >= this.m_58904_().m_151558_()) continue;
                    c.m_122178_(xx, yy, zz);
                    if (coordinateSet.containsKey(c) || (state = this.m_58904_().m_8055_((BlockPos)c)) != templateState || todo.contains(c)) continue;
                    todo.addLast(c.m_7949_());
                }
            }
        }
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.powerLevel = tagCompound.m_128445_("powered");
        this.shieldComposed = tagCompound.m_128471_("composed");
        this.shieldActive = tagCompound.m_128471_("active");
        this.powerTimeout = tagCompound.m_128451_("powerTimeout");
        if (tagCompound.m_128441_("templateColor")) {
            int templateColor = tagCompound.m_128451_("templateColor");
            ShieldTemplateBlock.TemplateColor color = ShieldTemplateBlock.TemplateColor.values()[templateColor];
            switch (color) {
                case BLUE: {
                    this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_BLUE.get()).m_49966_();
                    break;
                }
                case RED: {
                    this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_RED.get()).m_49966_();
                    break;
                }
                case GREEN: {
                    this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_GREEN.get()).m_49966_();
                    break;
                }
                case YELLOW: {
                    this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_YELLOW.get()).m_49966_();
                }
            }
        } else {
            this.templateState = Blocks.f_50016_.m_49966_();
        }
        this.loadEnergyCap(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            CompoundTag info = tagCompound.m_128469_("Info");
            this.shieldRenderingMode = ShieldRenderingMode.values()[info.m_128451_("visMode")];
            this.shieldTexture = ShieldTexture.values()[info.m_128451_("shieldTexture")];
            this.rsMode = RedstoneMode.values()[info.m_128445_("rsMode")];
            this.damageMode = DamageTypeMode.values()[info.m_128445_("damageMode")];
            this.blockLight = info.m_128471_("blocklight");
            this.shieldColor = info.m_128441_("shieldColor") ? info.m_128451_("shieldColor") : 9895880;
            this.readFiltersFromNBT(info);
        }
        this.renderData = null;
        RFToolsBuilderMessages.sendToServer(PacketNotifyServerClientReady.create(this.f_58858_));
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128344_("powered", (byte)this.powerLevel);
        tagCompound.m_128379_("composed", this.shieldComposed);
        tagCompound.m_128379_("active", this.shieldActive);
        tagCompound.m_128405_("powerTimeout", this.powerTimeout);
        if (!this.templateState.m_60795_()) {
            tagCompound.m_128405_("templateColor", ((ShieldTemplateBlock)this.templateState.m_60734_()).getColor().ordinal());
        }
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("visMode", this.shieldRenderingMode.ordinal());
        info.m_128405_("shieldTexture", this.shieldTexture.ordinal());
        info.m_128344_("rsMode", (byte)this.rsMode.ordinal());
        info.m_128344_("damageMode", (byte)this.damageMode.ordinal());
        info.m_128379_("blocklight", this.blockLight);
        info.m_128405_("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(info);
        this.saveEnergyCap(tagCompound);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.shieldComposed = tagCompound.m_128471_("composed");
        this.shieldActive = tagCompound.m_128471_("active");
        this.powerTimeout = tagCompound.m_128451_("powerTimeout");
        if (!this.isShapedShield()) {
            if (tagCompound.m_128441_("templateColor")) {
                int templateColor = tagCompound.m_128451_("templateColor");
                ShieldTemplateBlock.TemplateColor color = ShieldTemplateBlock.TemplateColor.values()[templateColor];
                switch (color) {
                    case BLUE: {
                        this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_BLUE.get()).m_49966_();
                        break;
                    }
                    case RED: {
                        this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_RED.get()).m_49966_();
                        break;
                    }
                    case GREEN: {
                        this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_GREEN.get()).m_49966_();
                        break;
                    }
                    case YELLOW: {
                        this.templateState = ((ShieldTemplateBlock)ShieldModule.TEMPLATE_YELLOW.get()).m_49966_();
                    }
                }
            } else {
                this.templateState = Blocks.f_50016_.m_49966_();
            }
        } else {
            this.templateState = Blocks.f_50016_.m_49966_();
        }
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (tagCompound.m_128441_("relcoordsNew")) {
            byte[] byteArray = tagCompound.m_128463_("relcoordsNew");
            int j = 0;
            for (int i = 0; i < byteArray.length / 8; ++i) {
                short dx = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                short st = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 6], byteArray[j + 7]);
                j += 8;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, st));
            }
            ListTag list = tagCompound.m_128437_("gstates", 10);
            for (Tag inbt : list) {
                CompoundTag tc = (CompoundTag)inbt;
                String b = tc.m_128461_("b");
                int m = tc.m_128451_("m");
                Block block = Tools.getBlock((ResourceLocation)new ResourceLocation(b));
                if (block == null) {
                    block = Blocks.f_50069_;
                    m = 0;
                }
                BlockState state = block.m_49966_();
                this.blockStateTable.add(state);
            }
        } else {
            byte[] byteArray = tagCompound.m_128463_("relcoords");
            int j = 0;
            for (int i = 0; i < byteArray.length / 6; ++i) {
                short dx = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                j += 6;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, -1));
            }
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        if (tagCompound.m_128441_("Info")) {
            CompoundTag info = tagCompound.m_128469_("Info");
            this.shieldRenderingMode = ShieldRenderingMode.values()[info.m_128451_("visMode")];
            this.shieldTexture = ShieldTexture.values()[info.m_128451_("shieldTexture")];
            this.damageMode = DamageTypeMode.values()[info.m_128445_("damageMode")];
            this.blockLight = info.m_128471_("blocklight");
            this.shieldColor = info.m_128441_("shieldColor") ? info.m_128451_("shieldColor") : 9895880;
            this.readFiltersFromNBT(info);
        }
    }

    private void readFiltersFromNBT(CompoundTag tagCompound) {
        this.filters.clear();
        ListTag filterList = tagCompound.m_128437_("filters", 10);
        for (int i = 0; i < filterList.size(); ++i) {
            CompoundTag compound = filterList.m_128728_(i);
            this.filters.add(AbstractShieldFilter.createFilter(compound));
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("composed", this.shieldComposed);
        tagCompound.m_128379_("active", this.shieldActive);
        tagCompound.m_128405_("powerTimeout", this.powerTimeout);
        if (!this.templateState.m_60795_()) {
            tagCompound.m_128405_("templateColor", ((ShieldTemplateBlock)this.templateState.m_60734_()).getColor().ordinal());
        }
        byte[] blocks = new byte[this.shieldBlocks.size() * 8];
        int j = 0;
        for (RelCoordinateShield c : this.shieldBlocks) {
            blocks[j + 0] = ShieldProjectorTileEntity.shortToByte1((short)c.dx());
            blocks[j + 1] = ShieldProjectorTileEntity.shortToByte2((short)c.dx());
            blocks[j + 2] = ShieldProjectorTileEntity.shortToByte1((short)c.dy());
            blocks[j + 3] = ShieldProjectorTileEntity.shortToByte2((short)c.dy());
            blocks[j + 4] = ShieldProjectorTileEntity.shortToByte1((short)c.dz());
            blocks[j + 5] = ShieldProjectorTileEntity.shortToByte2((short)c.dz());
            blocks[j + 6] = ShieldProjectorTileEntity.shortToByte1((short)c.state());
            blocks[j + 7] = ShieldProjectorTileEntity.shortToByte2((short)c.state());
            j += 8;
        }
        tagCompound.m_128382_("relcoordsNew", blocks);
        ListTag list = new ListTag();
        for (BlockState state : this.blockStateTable) {
            CompoundTag tc = new CompoundTag();
            tc.m_128359_("b", Tools.getId((BlockState)state).toString());
            list.add((Object)tc);
        }
        tagCompound.m_128365_("gstates", (Tag)list);
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("visMode", this.shieldRenderingMode.ordinal());
        info.m_128405_("shieldTexture", this.shieldTexture.ordinal());
        info.m_128344_("damageMode", (byte)this.damageMode.ordinal());
        info.m_128379_("blocklight", this.blockLight);
        info.m_128405_("shieldColor", this.shieldColor);
        this.writeFiltersToNBT(info);
    }

    private void writeFiltersToNBT(CompoundTag tagCompound) {
        ListTag filterList = new ListTag();
        for (ShieldFilter filter : this.filters) {
            CompoundTag compound = new CompoundTag();
            filter.writeToNBT(compound);
            filterList.add((Object)compound);
        }
        tagCompound.m_128365_("filters", (Tag)filterList);
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return ShieldProjectorTileEntity.this.shieldActive ? (long)ShieldProjectorTileEntity.this.getRfPerTick() : 0L;
            }

            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return ShieldProjectorTileEntity.this.shieldActive;
            }

            public boolean isMachineRunning() {
                return ShieldProjectorTileEntity.this.shieldActive;
            }

            public String getMachineStatus() {
                return ShieldProjectorTileEntity.this.shieldActive ? "active" : "idle";
            }
        };
    }
}

