/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public final class ShapeID {
    private final ResourceKey<Level> dimension;
    @Nullable
    private final BlockPos pos;
    private final int scanId;
    private final boolean grayscale;
    private final boolean solid;

    public ShapeID(ResourceKey<Level> dimension, @Nullable BlockPos pos, int scanId, boolean grayscale, boolean solid) {
        this.dimension = dimension;
        this.pos = pos;
        this.scanId = scanId;
        this.grayscale = grayscale;
        this.solid = solid;
    }

    public ShapeID(FriendlyByteBuf buf) {
        ResourceKey dim = Level.f_46428_;
        BlockPos p = null;
        if (buf.readBoolean()) {
            dim = LevelTools.getId((ResourceLocation)buf.m_130281_());
            p = buf.m_130135_();
        }
        this.scanId = buf.readInt();
        this.grayscale = buf.readBoolean();
        this.solid = buf.readBoolean();
        this.pos = p;
        this.dimension = dim;
    }

    public void toBytes(FriendlyByteBuf buf) {
        if (this.getPos() == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130085_(this.getDimension().m_135782_());
            buf.m_130064_(this.getPos());
        }
        buf.writeInt(this.scanId);
        buf.writeBoolean(this.grayscale);
        buf.writeBoolean(this.solid);
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    public int getScanId() {
        return this.scanId;
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeID shapeID = (ShapeID)o;
        if (!this.dimension.equals(shapeID.dimension)) {
            return false;
        }
        if (this.scanId != shapeID.scanId) {
            return false;
        }
        if (this.grayscale != shapeID.grayscale) {
            return false;
        }
        if (this.solid != shapeID.solid) {
            return false;
        }
        return this.pos != null ? this.pos.equals((Object)shapeID.pos) : shapeID.pos == null;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        result = 31 * result + this.scanId;
        result = 31 * result + (this.grayscale ? 1 : 0);
        result = 31 * result + (this.solid ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ShapeID{dimension=" + this.dimension + ", pos=" + this.pos + ", scanId=" + this.scanId + ", grayscale=" + this.grayscale + ", solid=" + this.solid + "}";
    }
}

