/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class FloatListListEntry
extends AbstractTextFieldListListEntry<Float, FloatListCell, FloatListListEntry> {
    private float minimum = Float.NEGATIVE_INFINITY;
    private float maximum = Float.POSITIVE_INFINITY;

    @Deprecated
    @ApiStatus.Internal
    public FloatListListEntry(Component fieldName, List<Float> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, Component resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public FloatListListEntry(Component fieldName, List<Float> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, Component resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    @ApiStatus.Internal
    public FloatListListEntry(Component fieldName, List<Float> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, Component resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, FloatListCell::new);
    }

    public FloatListListEntry setMaximum(float maximum) {
        this.maximum = maximum;
        return this;
    }

    public FloatListListEntry setMinimum(float minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public FloatListListEntry self() {
        return this;
    }

    public static class FloatListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Float, FloatListCell, FloatListListEntry> {
        public FloatListCell(Float value, FloatListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Float substituteDefault(@Nullable Float value) {
            if (value == null) {
                return Float.valueOf(0.0f);
            }
            return value;
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45 || c == 46);
        }

        @Override
        public Float getValue() {
            try {
                return Float.valueOf(this.widget.m_94155_());
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }

        @Override
        public Optional<Component> getError() {
            try {
                float i = Float.parseFloat(this.widget.m_94155_());
                if (i > ((FloatListListEntry)this.listListEntry).maximum) {
                    return Optional.of(Component.m_237110_((String)"text.cloth-config.error.too_large", (Object[])new Object[]{Float.valueOf(((FloatListListEntry)this.listListEntry).maximum)}));
                }
                if (i < ((FloatListListEntry)this.listListEntry).minimum) {
                    return Optional.of(Component.m_237110_((String)"text.cloth-config.error.too_small", (Object[])new Object[]{Float.valueOf(((FloatListListEntry)this.listListEntry).minimum)}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(Component.m_237115_((String)"text.cloth-config.error.not_valid_number_float"));
            }
            return Optional.empty();
        }
    }
}

