/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.compat;

import com.copycatsplus.copycats.CCLang;
import com.copycatsplus.copycats.compat.forge.ModsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.function.Supplier;

public enum Mods {
    JEI("jei"),
    EMI("emi"),
    CREATE("create"),
    ADDITIONAL_PLACEMENTS("additionalplacements"),
    DIAGONAL_FENCES("diagonalfences"),
    DIAGONAL_WALLS("diagonalwalls"),
    DIAGONAL_WINDOWS("diagonalwindows"),
    FLYWHEEL("flywheel"),
    SODIUM("sodium"),
    RUBIDIUM("rubidium"),
    ATHENA("athena"),
    INDIUM("indium"),
    LITHIUM("lithium"),
    RADIUM("radium"),
    STARLIGHT("starlight"),
    MORE_CULLING("moreculling"),
    DOUBLE_SLABS("doubleslabs"),
    VERTICAL_SLAB_COMPAT("v_slab_compat");

    public final String id;
    public final boolean isLoaded;

    private Mods() {
        this(null);
    }

    private Mods(String id) {
        this.id = id;
        this.isLoaded = Mods.getLoaded(CCLang.asId(id));
    }

    public String id() {
        return this.id;
    }

    public boolean getLoaded() {
        return this.isLoaded;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean getLoaded(String id) {
        return ModsImpl.getLoaded(id);
    }

    public <T> Optional<T> runIfInstalled(Supplier<Supplier<T>> toRun) {
        if (this.getLoaded()) {
            return Optional.of(toRun.get().get());
        }
        return Optional.empty();
    }

    public void executeIfInstalled(Supplier<Runnable> toExecute) {
        if (this.getLoaded()) {
            toExecute.get().run();
        }
    }
}

