/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.datagen.recipes.forge;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.datagen.recipes.forge.FeatureEnabledCondition;
import com.copycatsplus.copycats.datagen.recipes.gen.CopycatsRecipeProvider;
import com.copycatsplus.copycats.datagen.recipes.gen.GeneratedRecipeBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class GeneratedRecipeBuilderForge
implements GeneratedRecipeBuilder {
    private final List<ICondition> recipeConditions = new ArrayList<ICondition>();
    private String path = "";
    private String suffix;
    private Supplier<? extends ItemLike> result;
    private ResourceLocation compatDatagenOutput;
    private Supplier<ItemPredicate> unlockedBy;
    private int amount;

    private GeneratedRecipeBuilderForge(String path) {
        this.path = path;
        this.suffix = "";
        this.amount = 1;
    }

    public GeneratedRecipeBuilderForge(String path, Supplier<? extends ItemLike> result) {
        this(path);
        this.result = result;
    }

    public GeneratedRecipeBuilderForge(String path, ResourceLocation result) {
        this(path);
        this.compatDatagenOutput = result;
    }

    @Override
    public GeneratedRecipeBuilder returns(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
        this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
        return this;
    }

    @Override
    public GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
        this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
        return this;
    }

    @Override
    public GeneratedRecipeBuilder withSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
        return this.handleConditions(consumer -> {
            ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
            if (this.unlockedBy != null) {
                b.m_126132_("has_item", (CriterionTriggerInstance)RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
            }
            b.m_126140_(consumer, this.createLocation("crafting"));
        });
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
        return this.handleConditions(consumer -> {
            ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
            if (this.unlockedBy != null) {
                b.m_126132_("has_item", (CriterionTriggerInstance)RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
            }
            b.m_126140_(consumer, this.createLocation("crafting"));
        });
    }

    private ResourceLocation clean(ResourceLocation loc) {
        String path = loc.m_135815_();
        while (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        return new ResourceLocation(loc.m_135827_(), path);
    }

    private ResourceLocation createSimpleLocation(String recipeType) {
        ResourceLocation loc = this.clean(Copycats.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix));
        return loc;
    }

    protected ResourceLocation createLocation(String recipeType) {
        ResourceLocation loc = this.clean(Copycats.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix));
        return loc;
    }

    private ResourceLocation getRegistryName() {
        return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(this.result.get().m_5456_()) : this.compatDatagenOutput;
    }

    @Override
    public GeneratedRecipeBuilder requiresResultFeature() {
        return this.requiresFeature(CatnipServices.REGISTRIES.getKeyOrThrow(this.result.get().m_5456_()));
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(ResourceLocation location) {
        return this.requiresFeature(location, false);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block) {
        return this.requiresFeature(block, false);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(BlockEntry<?> block, boolean invert) {
        return this.requiresFeature(block.getId(), invert);
    }

    @Override
    public GeneratedRecipeBuilder requiresFeature(ResourceLocation location, boolean invert) {
        this.recipeConditions.add(new FeatureEnabledCondition(location, invert));
        return this;
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedRecipe handleConditions(Consumer<Consumer<FinishedRecipe>> recipe) {
        return CopycatsRecipeProvider.register(consumer -> {
            if (!this.recipeConditions.isEmpty()) {
                ConditionalRecipe.Builder b = ConditionalRecipe.builder();
                this.recipeConditions.forEach(arg_0 -> ((ConditionalRecipe.Builder)b).addCondition(arg_0));
                b.addRecipe(recipe);
                b.generateAdvancement();
                b.build(consumer, this.createLocation("crafting"));
            } else {
                recipe.accept(consumer);
            }
        });
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
        return this.unlockedBy(item).viaCookingIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
        return this.unlockedByTag(tag).viaCookingIngredient(() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get())));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
        return new GeneratedCookingRecipeBuilderForge(ingredient);
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecutting(Supplier<? extends ItemLike> item) {
        return this.unlockedBy(item).viaStonecuttingIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecuttingTag(Supplier<TagKey<Item>> tag) {
        return this.unlockedByTag(tag).viaStonecuttingIngredient(() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get())));
    }

    @Override
    public GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder viaStonecuttingIngredient(Supplier<Ingredient> ingredient) {
        return new GeneratedStoneCuttingRecipeBuilderForge(ingredient);
    }

    public class GeneratedCookingRecipeBuilderForge
    implements GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder {
        private final Supplier<Ingredient> ingredient;
        private float exp;
        private int cookingTime;
        private final RecipeSerializer<? extends AbstractCookingRecipe> FURNACE = RecipeSerializer.f_44091_;
        private final RecipeSerializer<? extends AbstractCookingRecipe> SMOKER = RecipeSerializer.f_44093_;
        private final RecipeSerializer<? extends AbstractCookingRecipe> BLAST = RecipeSerializer.f_44092_;
        private final RecipeSerializer<? extends AbstractCookingRecipe> CAMPFIRE = RecipeSerializer.f_44094_;

        GeneratedCookingRecipeBuilderForge(Supplier<Ingredient> ingredient) {
            this.ingredient = ingredient;
            this.cookingTime = 200;
            this.exp = 0.0f;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder forDuration(int duration) {
            this.cookingTime = duration;
            return this;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedCookingRecipeBuilder rewardXP(float xp) {
            this.exp = xp;
            return this;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inFurnace() {
            return this.inFurnace(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
            return this.create(this.FURNACE, builder, 1.0f);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inSmoker() {
            return this.inSmoker(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
            this.create(this.FURNACE, builder, 1.0f);
            this.create(this.CAMPFIRE, builder, 3.0f);
            return this.create(this.SMOKER, builder, 0.5f);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inBlastFurnace() {
            return this.inBlastFurnace(b -> b);
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
            this.create(this.FURNACE, builder, 1.0f);
            return this.create(this.BLAST, builder, 0.5f);
        }

        private GeneratedRecipeBuilder.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
            return CopycatsRecipeProvider.register(consumer -> {
                boolean isOtherMod = GeneratedRecipeBuilderForge.this.compatDatagenOutput != null;
                SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : GeneratedRecipeBuilderForge.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                if (GeneratedRecipeBuilderForge.this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilderForge.this.unlockedBy.get()}));
                }
                b.m_126140_(consumer::accept, GeneratedRecipeBuilderForge.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).m_135815_()));
            });
        }
    }

    public class GeneratedStoneCuttingRecipeBuilderForge
    implements GeneratedRecipeBuilder.GeneratedStoneCuttingRecipeBuilder {
        private final Supplier<Ingredient> ingredient;

        GeneratedStoneCuttingRecipeBuilderForge(Supplier<Ingredient> ingredient) {
            this.ingredient = ingredient;
        }

        @Override
        public GeneratedRecipeBuilder.GeneratedRecipe create() {
            return this.create(b -> b);
        }

        private GeneratedRecipeBuilder.GeneratedRecipe create(UnaryOperator<SingleItemRecipeBuilder> builder) {
            return GeneratedRecipeBuilderForge.this.handleConditions(consumer -> {
                SingleItemRecipeBuilder b = (SingleItemRecipeBuilder)builder.apply(SingleItemRecipeBuilder.m_246944_((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)GeneratedRecipeBuilderForge.this.result.get(), (int)GeneratedRecipeBuilderForge.this.amount));
                if (GeneratedRecipeBuilderForge.this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RegistrateRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilderForge.this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, GeneratedRecipeBuilderForge.this.createLocation("stonecutting"));
            });
        }
    }
}

