/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client;

import dev.imb11.fog.api.CustomFogDefinition;
import dev.imb11.fog.api.FogColors;
import dev.imb11.fog.client.registry.FogRegistry;
import dev.imb11.fog.client.util.math.DarknessCalculation;
import dev.imb11.fog.client.util.math.InterpolatedValue;
import dev.imb11.fog.client.util.math.MathUtil;
import dev.imb11.fog.client.util.player.PlayerUtil;
import dev.imb11.fog.client.util.world.ClientWorldUtil;
import dev.imb11.fog.config.FogConfig;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    public static FogManager INSTANCE = new FogManager();
    public final InterpolatedValue raininess;
    public final InterpolatedValue undergroundness;
    public final InterpolatedValue fogStart;
    public final InterpolatedValue fogEnd;
    public final InterpolatedValue darkness;
    public final InterpolatedValue fogColorRed;
    public final InterpolatedValue fogColorGreen;
    public final InterpolatedValue fogColorBlue;
    public final InterpolatedValue currentSkyLight;
    public final InterpolatedValue currentBlockLight;
    public final InterpolatedValue currentLight;
    public final InterpolatedValue currentStartMultiplier;
    public final InterpolatedValue currentEndMultiplier;
    public boolean hasSetup = false;

    public FogManager() {
        @NotNull FogConfig config = FogConfig.getInstance();
        this.raininess = new InterpolatedValue(0.0f, config.raininessTransitionSpeed);
        this.undergroundness = new InterpolatedValue(0.0f, config.undergroundnessTransitionSpeed);
        this.fogStart = new InterpolatedValue(config.initialFogStart, config.fogStartTransitionSpeed);
        this.fogEnd = new InterpolatedValue(config.initialFogEnd, config.fogEndTransitionSpeed);
        this.darkness = new InterpolatedValue(0.0f, config.darknessTransitionSpeed);
        this.fogColorRed = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.fogColorGreen = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.fogColorBlue = new InterpolatedValue(-1.0f, config.fogColorTransitionSpeed);
        this.currentSkyLight = new InterpolatedValue(16.0f);
        this.currentBlockLight = new InterpolatedValue(16.0f);
        this.currentLight = new InterpolatedValue(16.0f);
        this.currentStartMultiplier = new InterpolatedValue(1.0f, config.startMultiplierTransitionSpeed);
        this.currentEndMultiplier = new InterpolatedValue(1.0f, config.endMultiplierTransitionSpeed);
        this.fogStart.resetTo(config.initialFogStart);
        this.fogEnd.resetTo(config.initialFogEnd);
    }

    @NotNull
    public static FogManager getInstance() {
        return INSTANCE;
    }

    public void onEndTick(@NotNull ClientLevel clientWorld) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer clientPlayer = client.f_91074_;
        if (clientPlayer == null) {
            return;
        }
        @Nullable BlockPos clientPlayerBlockPosition = clientPlayer.m_20183_();
        if (clientPlayerBlockPosition == null) {
            return;
        }
        boolean isClientPlayerAboveGround = PlayerUtil.isPlayerAboveGround(clientPlayer);
        if (isClientPlayerAboveGround) {
            this.undergroundness.interpolate(0.0f);
        } else {
            this.undergroundness.interpolate(1.0f);
        }
        if (isClientPlayerAboveGround && ((Biome)clientWorld.m_204166_(clientPlayer.m_20183_()).m_203334_()).m_264473_() && clientWorld.m_46471_()) {
            this.raininess.interpolate(1.0f);
        } else {
            this.raininess.interpolate(0.0f);
        }
        float density = ClientWorldUtil.isFogDenseAtPosition(clientWorld, clientPlayerBlockPosition) ? 0.9f : 1.0f;
        float tickDelta = client.m_91296_();
        DarknessCalculation darknessCalculation = DarknessCalculation.of(client, this.fogStart.getDefaultValue(), this.fogEnd.getDefaultValue() * density, tickDelta);
        Optional clientPlayerBiomeKeyOptional = clientWorld.m_204166_(clientPlayer.m_20183_()).m_203543_();
        if (clientPlayerBiomeKeyOptional.isEmpty()) {
            return;
        }
        CustomFogDefinition fogDefinition = FogRegistry.getFogDefinitionOrDefault(((ResourceKey)clientPlayerBiomeKeyOptional.get()).m_135782_(), (Level)clientWorld);
        @Nullable FogColors colors = fogDefinition.colors();
        if (colors == null || FogConfig.getInstance().disableBiomeFogColour) {
            colors = FogColors.DEFAULT;
        }
        float blendFactor = FogManager.getBlendFactor(clientWorld);
        float red = Mth.m_14179_((float)blendFactor, (float)((float)colors.getNightColor().red / 255.0f), (float)((float)colors.getDayColor().red / 255.0f));
        float green = Mth.m_14179_((float)blendFactor, (float)((float)colors.getNightColor().green / 255.0f), (float)((float)colors.getDayColor().green / 255.0f));
        float blue = Mth.m_14179_((float)blendFactor, (float)((float)colors.getNightColor().blue / 255.0f), (float)((float)colors.getDayColor().blue / 255.0f));
        if (!this.hasSetup) {
            this.fogColorRed.set(red);
            this.fogColorGreen.set(green);
            this.fogColorBlue.set(blue);
            this.hasSetup = true;
        } else {
            this.fogColorRed.interpolate(red);
            this.fogColorGreen.interpolate(green);
            this.fogColorBlue.interpolate(blue);
        }
        this.currentStartMultiplier.interpolate(fogDefinition.startMultiplier());
        this.currentEndMultiplier.interpolate(fogDefinition.endMultiplier());
        this.fogStart.interpolate(darknessCalculation.fogStart());
        this.fogEnd.interpolate(darknessCalculation.fogEnd());
        this.darkness.interpolate(darknessCalculation.darknessValue());
        this.currentSkyLight.interpolate(clientWorld.m_45517_(LightLayer.SKY, clientPlayerBlockPosition));
        this.currentBlockLight.interpolate(clientWorld.m_45517_(LightLayer.BLOCK, clientPlayerBlockPosition));
        this.currentLight.interpolate(clientWorld.m_45524_(clientPlayerBlockPosition, 0));
    }

    private static float getBlendFactor(@NotNull ClientLevel world) {
        long time = world.m_46468_() % 24000L;
        float blendFactor = time < 11000L ? 1.0f : (time < 13000L ? MathUtil.lerp(1.0f, 0.0f, (float)(time - 11000L) / 2000.0f) : (time < 22000L ? 0.0f : (time < 23000L ? MathUtil.lerp(0.0f, 1.0f, (float)(time - 22000L) / 1000.0f) : 1.0f)));
        return blendFactor;
    }

    public float getUndergroundFactor(@NotNull Minecraft client, float deltaTicks) {
        Entity clientCamera = client.f_91075_;
        ClientLevel clientWorld = client.f_91073_;
        if (clientCamera == null || clientWorld == null) {
            return 0.0f;
        }
        float clientCameraYPosition = (float)clientCamera.m_20186_();
        float seaLevel = clientWorld.m_5736_();
        float yFactor = Mth.m_14036_((float)MathUtil.mapRange(seaLevel - 32.0f, seaLevel + 32.0f, 1.0f, 0.0f, clientCameraYPosition), (float)0.0f, (float)1.0f);
        float undergroundnessValue = this.undergroundness.get(deltaTicks);
        float skyLight = this.currentSkyLight.get(deltaTicks);
        return Mth.m_14179_((float)yFactor, (float)(1.0f - undergroundnessValue), (float)(skyLight / 16.0f));
    }

    @NotNull
    public FogSettings getFogSettings(float tickDelta, float viewDistance) {
        float fogStartValue = this.fogStart.get(tickDelta) * viewDistance;
        float undergroundFogMultiplier = 1.0f;
        if (!FogConfig.getInstance().disableUndergroundFogMultiplier) {
            undergroundFogMultiplier = this.undergroundness.get(tickDelta);
            undergroundFogMultiplier = Mth.m_14179_((float)this.darkness.get(tickDelta), (float)undergroundFogMultiplier, (float)1.0f);
        }
        float fogEndValue = viewDistance * this.fogEnd.get(tickDelta);
        if (undergroundFogMultiplier > 0.0f) {
            fogEndValue /= 1.0f + undergroundFogMultiplier;
            fogStartValue *= Math.max(0.1f, 0.5f - undergroundFogMultiplier);
        }
        float fogRed = this.fogColorRed.get(tickDelta);
        float fogGreen = this.fogColorGreen.get(tickDelta);
        float fogBlue = this.fogColorBlue.get(tickDelta);
        float raininessValue = this.raininess.get(tickDelta);
        if (!FogConfig.getInstance().disableRaininessEffect && raininessValue > 0.0f) {
            fogEndValue /= 1.0f + raininessValue;
            fogRed = Math.max(0.1f, fogRed - 0.5f * raininessValue);
            fogGreen = Math.max(0.1f, fogGreen - 0.5f * raininessValue);
            fogBlue = Math.max(0.1f, fogBlue - 0.5f * raininessValue);
        }
        float darknessValue = this.darkness.get(tickDelta);
        return new FogSettings(fogStartValue *= this.currentStartMultiplier.get(tickDelta), fogEndValue *= this.currentEndMultiplier.get(tickDelta), fogRed *= 1.0f - darknessValue, fogGreen *= 1.0f - darknessValue, fogBlue *= 1.0f - darknessValue);
    }

    public record FogSettings(double fogStart, double fogEnd, float fogRed, float fogGreen, float fogBlue) {
    }
}

