/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.mixin.client.rendering;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.math.EnvironmentCalculations;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.level.material.FogType;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FogRenderer.class})
public abstract class BackgroundRendererMixin {
    @Shadow
    private static float f_109010_;
    @Shadow
    private static float f_109011_;
    @Shadow
    private static float f_109012_;

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clearColor(FFFF)V", remap=false, shift=At.Shift.BEFORE)})
    private static void fog$modifyFogColors(@NotNull Camera camera, float tickDelta, @NotNull ClientLevel world, int viewDistance, float skyDarkness, @NotNull CallbackInfo ci) {
        if (FogConfig.getInstance().disableMod || FogConfig.getInstance().disabledDimensions.contains(world.m_46472_().m_135782_().toString()) || camera.m_167685_() != FogType.NONE) {
            return;
        }
        FogManager fogManager = FogManager.getInstance();
        FogManager.FogSettings fogSettings = fogManager.getFogSettings(tickDelta, viewDistance);
        if (!world.m_6042_().m_63967_() || !(world.m_104583_() instanceof DimensionSpecialEffects.EndEffects)) {
            fogSettings = EnvironmentCalculations.apply(fogManager.getUndergroundFactor(Minecraft.m_91087_(), tickDelta), fogSettings, tickDelta);
        }
        f_109010_ = fogSettings.fogRed();
        f_109011_ = fogSettings.fogGreen();
        f_109012_ = fogSettings.fogBlue();
    }

    @Inject(method={"applyFog"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", remap=false, shift=At.Shift.BEFORE)})
    private static void fog$fogRenderEvent(@NotNull Camera camera, @NotNull FogRenderer.FogMode fogType, float viewDistance, boolean thickFog, float deltaTick, @NotNull CallbackInfo ci, @Local @NotNull FogRenderer.FogData fogData) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (clientWorld == null || FogConfig.getInstance().disableMod || FogConfig.getInstance().disabledDimensions.contains(clientWorld.m_46472_().m_135782_().toString()) || camera.m_167685_() != FogType.NONE) {
            return;
        }
        FogManager.FogSettings fogSettings = FogManager.getInstance().getFogSettings(deltaTick, viewDistance);
        fogData.f_234200_ = (float)fogSettings.fogStart();
        fogData.f_234201_ = (float)fogSettings.fogEnd();
        fogData.f_234202_ = FogShape.SPHERE;
    }

    @Inject(method={"setFogBlack"}, at={@At(value="HEAD")})
    private static void fog$setFogBlackChangeClearColor(@NotNull CallbackInfo ci) {
        if (FogConfig.getInstance().disableMod) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        ClientLevel clientWorld = client.f_91073_;
        Camera camera = client.f_91063_.m_109153_();
        if (clientWorld == null || camera == null || FogConfig.getInstance().disabledDimensions.contains(clientWorld.m_46472_().m_135782_().toString()) || camera.m_167685_() != FogType.NONE) {
            return;
        }
        float tickDelta = client.m_91296_();
        FogManager fogManager = FogManager.getInstance();
        FogManager.FogSettings fogSettings = fogManager.getFogSettings(tickDelta, ((Integer)client.f_91066_.m_231984_().m_231551_()).intValue());
        if (!clientWorld.m_6042_().m_63967_() || !(clientWorld.m_104583_() instanceof DimensionSpecialEffects.EndEffects)) {
            fogSettings = EnvironmentCalculations.apply(fogManager.getUndergroundFactor(client, tickDelta), fogSettings, tickDelta);
        }
        RenderSystem.clearColor((float)fogSettings.fogRed(), (float)fogSettings.fogGreen(), (float)fogSettings.fogBlue(), (float)1.0f);
    }
}

