/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.pipes;

import earth.terrarium.adastra.common.blockentities.pipes.PipeBlockEntity;
import earth.terrarium.adastra.common.blocks.properties.PipeProperty;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class FluidPipeBlockEntity
extends PipeBlockEntity {
    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void addNode(@NotNull BlockEntity entity, PipeProperty pipeProperty, Direction direction, BlockPos pos) {
        if (pipeProperty.isNone()) {
            return;
        }
        FluidContainer container = FluidContainer.of((BlockEntity)entity, (Direction)direction);
        if (container == null) {
            return;
        }
        FluidHolder toTransfer = container.getFirstFluid();
        if (!(pipeProperty.isInsert() || toTransfer.isEmpty() || !pipeProperty.isExtract() && container.extractFluid(toTransfer, true).getFluidAmount() <= 0L)) {
            this.sources.put(pos, direction);
        } else if (pipeProperty.isNormal() || pipeProperty.isInsert()) {
            this.consumers.put(pos, direction);
        }
    }

    @Override
    public void moveContents(long transferRate, @NotNull BlockEntity source, @NotNull BlockEntity consumer, Direction direction) {
        if (!FluidContainer.holdsFluid((BlockEntity)source, (Direction)direction)) {
            return;
        }
        FluidContainer sourceContainer = FluidContainer.of((BlockEntity)source, (Direction)direction);
        if (sourceContainer == null) {
            return;
        }
        if (!FluidContainer.holdsFluid((BlockEntity)consumer, (Direction)direction)) {
            return;
        }
        FluidContainer consumerContainer = FluidContainer.of((BlockEntity)consumer, (Direction)direction.m_122424_());
        if (consumerContainer == null) {
            return;
        }
        for (FluidHolder fluid : sourceContainer.getFluids()) {
            FluidHolder toTransfer;
            if (fluid.isEmpty() || (toTransfer = FluidHolder.ofMillibuckets((Fluid)fluid.getFluid(), (long)Math.min(transferRate, fluid.getFluidAmount()))).isEmpty()) continue;
            try {
                FluidApi.moveFluid((FluidContainer)sourceContainer, (FluidContainer)consumerContainer, (FluidHolder)toTransfer, (boolean)true);
                FluidApi.moveFluid((FluidContainer)sourceContainer, (FluidContainer)consumerContainer, (FluidHolder)toTransfer, (boolean)false);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Override
    public boolean isValid(@NotNull BlockEntity entity, Direction direction) {
        return FluidContainer.holdsFluid((BlockEntity)entity, (Direction)direction.m_122424_());
    }
}

