/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.Nullable;

public final class GlareLocateDarkSpotTask
extends Behavior<GlareEntity> {
    public GlareLocateDarkSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), MemoryStatus.VALUE_ABSENT), 1);
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        return GlareLocateDarkSpotTask.canLocateDarkSpot(glare);
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        BlockPos darkSpotPos = this.findRandomDarkSpot(glare);
        if (darkSpotPos == null) {
            GlareBrain.setDarkSpotLocatingCooldown(glare, TimeUtil.m_145020_((int)10, (int)10));
            return;
        }
        ResourceKey registryKey = glare.m_9236_().m_46472_();
        glare.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), (Object)GlobalPos.m_122643_((ResourceKey)registryKey, (BlockPos)darkSpotPos));
    }

    private ArrayList<BlockPos> findDarkSpots(GlareEntity glare) {
        ServerLevel serverWorld = (ServerLevel)glare.m_20193_();
        BlockPos blockPos = glare.m_20183_();
        ArrayList<BlockPos> darkSpots = new ArrayList<BlockPos>();
        int searchDistance = 16;
        int i = 0;
        while ((double)i <= (double)searchDistance) {
            int j = 0;
            while ((double)j < (double)searchDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        boolean isBlockAccessible;
                        BlockPos.MutableBlockPos possibleDarkSpotBlockPos = new BlockPos.MutableBlockPos();
                        possibleDarkSpotBlockPos.m_122154_((Vec3i)blockPos, k, i - 1, l);
                        boolean isBlockWithinDistance = blockPos.m_123314_((Vec3i)possibleDarkSpotBlockPos, (double)searchDistance);
                        boolean isSpotDarkEnough = glare.m_9236_().m_45517_(LightLayer.BLOCK, (BlockPos)possibleDarkSpotBlockPos) == 0;
                        boolean isBlockSolidSurface = serverWorld.m_8055_(possibleDarkSpotBlockPos.m_7495_()).m_60634_((BlockGetter)serverWorld, (BlockPos)possibleDarkSpotBlockPos, (Entity)glare);
                        boolean bl = isBlockAccessible = serverWorld.m_46859_((BlockPos)possibleDarkSpotBlockPos) && serverWorld.m_46859_(possibleDarkSpotBlockPos.m_7494_());
                        if (isBlockWithinDistance && isBlockSolidSurface && isBlockAccessible && isSpotDarkEnough) {
                            darkSpots.add((BlockPos)possibleDarkSpotBlockPos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return darkSpots;
    }

    @Nullable
    private BlockPos findRandomDarkSpot(GlareEntity glare) {
        ArrayList<BlockPos> darkSpots = this.findDarkSpots(glare);
        if (darkSpots.isEmpty()) {
            return null;
        }
        return darkSpots.get(glare.m_217043_().m_188503_(darkSpots.size()));
    }

    public static boolean canLocateDarkSpot(GlareEntity glare) {
        return !glare.m_21523_() && !glare.m_21827_() && !glare.m_20159_() && glare.m_21824_() && !glare.m_6162_() && (!glare.m_9236_().m_46461_() || !glare.m_9236_().m_45527_(glare.m_20183_()));
    }
}

