/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.item;

import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ItemUsableResource {
    Energy{

        @Override
        public boolean test(ItemStack item) {
            return EnergyApi.isEnergyItem((ItemStack)item);
        }

        @Override
        public long extract(LivingEntity living, EquipmentSlot slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(item, amount, simulate);
        }

        @Override
        public long extract(LivingEntity living, byte slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(item, amount, simulate);
        }

        @Override
        public long extract(LivingEntity living, InteractionHand hand, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(item, amount, simulate);
        }

        private Long extract(ItemStackReference item, long amount, boolean simulate) {
            EnergyContainer energyContainer = EnergyContainer.of((ItemStackHolder)item);
            return energyContainer != null ? energyContainer.extractEnergy(amount, simulate) : 0L;
        }
    }
    ,
    Durability{

        @Override
        public boolean test(ItemStack item) {
            return true;
        }

        @Override
        public long extract(LivingEntity living, byte slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(living, item, amount, simulate, l -> l.m_9236_().m_7605_((Entity)l, slot));
        }

        @Override
        public long extract(LivingEntity living, EquipmentSlot slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(living, item, amount, simulate, l -> l.m_21166_(slot));
        }

        @Override
        public long extract(LivingEntity living, InteractionHand hand, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(living, item, amount, simulate, l -> l.m_21190_(hand));
        }

        private long extract(LivingEntity living, ItemStackReference item, long amount, boolean simulate, Consumer<LivingEntity> onBreak) {
            ItemStack stack = item.getStack();
            if (stack.m_41763_() && !simulate) {
                stack.m_41622_((int)amount, living, onBreak);
                item.setStack(stack);
            }
            return amount;
        }
    };


    @Nullable
    public static ItemUsableResource first(ItemStack item) {
        for (ItemUsableResource resource : ItemUsableResource.values()) {
            if (!resource.test(item)) continue;
            return resource;
        }
        return null;
    }

    public abstract boolean test(ItemStack var1);

    public abstract long extract(LivingEntity var1, byte var2, ItemStackReference var3, long var4, boolean var6);

    public abstract long extract(LivingEntity var1, EquipmentSlot var2, ItemStackReference var3, long var4, boolean var6);

    public abstract long extract(LivingEntity var1, InteractionHand var2, ItemStackReference var3, long var4, boolean var6);
}

