/*
 * Decompiled with CFR 0.152.
 */
package com.example.SoundOfRain;

import com.example.SoundOfRain.SoundOfRainConfig;
import com.example.SoundOfRain.SoundRegistry;
import com.example.SoundOfRain.ThunderSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LightningBolt;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SoundOverrideHandler {
    private final ThunderSoundHandler thunderSoundHandler;

    public SoundOverrideHandler(ThunderSoundHandler thunderSoundHandler) {
        this.thunderSoundHandler = thunderSoundHandler;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLightningStrike(EntityStruckByLightningEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            boolean isSingleplayer;
            Minecraft mc = Minecraft.m_91087_();
            boolean bl = isSingleplayer = mc != null && mc.m_91090_();
            if (!isSingleplayer) {
                return;
            }
            BlockPos strikePos = event.getLightning().m_20183_();
            this.thunderSoundHandler.handleLightningStrike(strikePos);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoin(EntityJoinLevelEvent event) {
        if (!(event.getEntity() instanceof LightningBolt)) {
            return;
        }
        if (event.getLevel().m_5776_()) {
            boolean isSingleplayer;
            Minecraft mc = Minecraft.m_91087_();
            boolean bl = isSingleplayer = mc != null && mc.m_91090_();
            if (!isSingleplayer) {
                return;
            }
            BlockPos strikePos = event.getEntity().m_20183_();
            this.thunderSoundHandler.handleLightningStrike(strikePos);
        }
    }

    @Mod.EventBusSubscriber(modid="soundofrain", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SoundHandler {
        @SubscribeEvent
        public static void onPlaySound(PlaySoundEvent event) {
            boolean hasCustomSounds;
            boolean isThunder;
            if (!((Boolean)SoundOfRainConfig.CLIENT.thunderSounds.get()).booleanValue()) {
                return;
            }
            if (event.getSound() == null || event.getSound().m_7904_() == null) {
                return;
            }
            ResourceLocation soundLocation = event.getSound().m_7904_();
            boolean bl = isThunder = soundLocation.equals((Object)SoundEvents.f_12090_.m_11660_()) || soundLocation.equals((Object)SoundEvents.f_12089_.m_11660_());
            if (!isThunder) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            boolean isSingleplayer = mc != null && mc.m_91090_();
            boolean bl2 = hasCustomSounds = SoundRegistry.THUNDER_CLOSE.isPresent() || SoundRegistry.THUNDER_MEDIUM.isPresent() || SoundRegistry.THUNDER_FAR.isPresent();
            if (isSingleplayer && hasCustomSounds) {
                event.setSound(null);
            }
        }
    }
}

