/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="storagedrawers")
public class CommonEventBusSubscriber {
    @SubscribeEvent
    public static void playerLeftClick(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BlockDrawers) {
            BlockHitResult hit;
            BlockDrawers blockDrawers = (BlockDrawers)block;
            Player player = event.getEntity();
            if (player.m_7500_() && (hit = WorldUtils.rayTraceEyes(level, player, pos)).m_6662_() == HitResult.Type.BLOCK) {
                blockDrawers.leftAction(state, level, pos, player, hit);
                event.setCanceled(blockDrawers.getFaceSlot(state, hit) >= 0);
            }
        }
    }

    @SubscribeEvent
    public static void itemStackedOn(ItemStackedOnOtherEvent event) {
        if (!(event.getStackedOnItem().m_41720_() instanceof ItemUpgradeStorage)) {
            return;
        }
        if (!(event.getCarriedItem().m_41720_() instanceof ItemUpgradeStorage)) {
            return;
        }
        Slot slot = event.getSlot();
        if (slot instanceof SlotUpgrade) {
            SlotUpgrade slot2 = (SlotUpgrade)slot;
            ItemStack stacked = event.getStackedOnItem();
            ItemStack carried = event.getCarriedItem();
            ItemStack slotStack = event.getSlot().m_7993_();
            if (ItemStack.m_41728_((ItemStack)slotStack, (ItemStack)carried) && !ItemStack.m_41728_((ItemStack)slotStack, (ItemStack)stacked)) {
                carried = event.getStackedOnItem();
                stacked = event.getCarriedItem();
            }
            if (slot2.canSwapStack(carried)) {
                event.getSlot().m_5852_(carried);
                event.getCarriedSlotAccess().m_142104_(stacked);
                event.setCanceled(true);
            }
        }
    }
}

