/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.dynamic;

import com.mojang.datafixers.util.Either;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.api.config.TagPair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class TagPairHelper {
    protected static HashMap<ResourceLocation, TagPair> LOADED_TAG_PAIRS = new HashMap();
    protected static HashMap<ResourceLocation, ResourceLocation> BLOCK_CACHE = new HashMap();

    public static Collection<TagPair> getAllTagPairs() {
        return LOADED_TAG_PAIRS.values();
    }

    public static void buildCache() {
        BLOCK_CACHE.clear();
        for (Map.Entry<ResourceLocation, TagPair> entry : LOADED_TAG_PAIRS.entrySet()) {
            ResourceLocation id = entry.getKey();
            TagPair val = entry.getValue();
            for (Either<ResourceKey<Block>, TagKey<Block>> registryKeyTagKeyEither : val.getKeys().getInternalList()) {
                if (registryKeyTagKeyEither.left().isPresent()) {
                    BLOCK_CACHE.put(((ResourceKey)registryKeyTagKeyEither.left().get()).m_135782_(), id);
                    continue;
                }
                if (!registryKeyTagKeyEither.right().isPresent()) continue;
                Optional vals = BuiltInRegistries.f_256975_.m_203431_((TagKey)registryKeyTagKeyEither.right().get());
                if (vals.isPresent()) {
                    for (Holder block : (HolderSet.Named)vals.get()) {
                        BLOCK_CACHE.put(((ResourceKey)block.m_203543_().get()).m_135782_(), id);
                    }
                    continue;
                }
                SoundsClient.LOGGER.warn("Failed to find block entries for tag key: " + String.valueOf(((TagKey)registryKeyTagKeyEither.right().get()).f_203868_()));
            }
        }
    }

    public static TagPair get(ResourceLocation id) {
        ResourceLocation cacheVal = BLOCK_CACHE.get(id);
        if (cacheVal == null) {
            return null;
        }
        return LOADED_TAG_PAIRS.get(cacheVal);
    }
}

