/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.sound.events;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.imb11.sounds.config.EventSoundsConfig;
import dev.imb11.sounds.config.SoundsConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class PotionEventHelper {
    private static final AtomicReference<Map<ResourceLocation, MobEffectInstance>> previousEffects = new AtomicReference<Object>(null);

    public static void initialize() {
        ClientTickEvent.CLIENT_LEVEL_PRE.register(PotionEventHelper::listenForEffectChanges);
    }

    private static void listenForEffectChanges(ClientLevel clientWorld) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            return;
        }
        HashMap currentEffects = new HashMap();
        client.f_91074_.m_21220_().forEach(effectInstance -> {
            MobEffect effect = effectInstance.m_19544_();
            currentEffects.put(BuiltInRegistries.f_256974_.m_7981_((Object)effect), effectInstance);
        });
        if (previousEffects.get() != null) {
            HashMap<ResourceLocation, MobEffectInstance> removedEffects = new HashMap<ResourceLocation, MobEffectInstance>(previousEffects.get());
            removedEffects.keySet().removeAll(currentEffects.keySet());
            for (ResourceLocation effectId : removedEffects.keySet()) {
                MobEffect statusEffect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
                if (statusEffect == null || SoundsConfig.get(EventSoundsConfig.class).ignoreSilencedStatusEffects && !((MobEffectInstance)removedEffects.get(effectId)).m_19575_()) continue;
                if (statusEffect.m_19486_()) {
                    SoundsConfig.get(EventSoundsConfig.class).positiveStatusEffectLoseSoundEffect.playSound();
                    continue;
                }
                SoundsConfig.get(EventSoundsConfig.class).negativeStatusEffectLoseSoundEffect.playSound();
            }
            HashMap addedEffects = new HashMap(currentEffects);
            addedEffects.keySet().removeAll(previousEffects.get().keySet());
            for (ResourceLocation effectId : addedEffects.keySet()) {
                MobEffect statusEffect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
                if (statusEffect == null || SoundsConfig.get(EventSoundsConfig.class).ignoreSilencedStatusEffects && !((MobEffectInstance)addedEffects.get(effectId)).m_19575_()) continue;
                if (statusEffect.m_19486_()) {
                    SoundsConfig.get(EventSoundsConfig.class).positiveStatusEffectGainSoundEffect.playSound();
                    continue;
                }
                SoundsConfig.get(EventSoundsConfig.class).negativeStatusEffectGainSoundEffect.playSound();
            }
        }
        previousEffects.set(currentEffects);
    }
}

