/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.cycle_menu;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class TagCycleTracker {
    private final List<TagKey<Item>> CYCLING_TAGS = new ArrayList<TagKey<Item>>();
    private final Map<TagKey<Item>, List<Item>> CYCLES = new HashMap<TagKey<Item>, List<Item>>();
    private final Map<Item, TagKey<Item>> REVERSE_LOOKUP = new HashMap<Item, TagKey<Item>>();
    private boolean cyclesComputed = false;

    public void registerCycle(TagKey<Item> tag) {
        if (!this.CYCLING_TAGS.contains(tag)) {
            this.CYCLING_TAGS.add(tag);
        }
    }

    public void scheduleRecompute() {
        this.cyclesComputed = false;
    }

    public void computeCycles() {
        this.CYCLES.clear();
        this.REVERSE_LOOKUP.clear();
        this.CYCLING_TAGS.forEach(tag -> this.CYCLES.put((TagKey<Item>)tag, new ArrayList()));
        BuiltInRegistries.f_257033_.m_203611_().forEachOrdered(item -> {
            for (TagKey<Item> tag : this.CYCLING_TAGS) {
                if (!item.m_203656_(tag)) continue;
                this.CYCLES.get(tag).add((Item)item.m_203334_());
                this.REVERSE_LOOKUP.put((Item)item.m_203334_(), tag);
            }
        });
        this.cyclesComputed = true;
    }

    @Nullable
    public TagKey<Item> getCycleTag(Item item) {
        if (!this.cyclesComputed) {
            this.computeCycles();
        }
        return this.REVERSE_LOOKUP.get(item);
    }

    public List<Item> getCycle(TagKey<Item> tag) {
        if (!this.cyclesComputed) {
            this.computeCycles();
        }
        return this.CYCLES.getOrDefault(tag, (List<Item>)ImmutableList.of());
    }
}

