/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.emi.emi.EmiPort;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.data.TagExclusions;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiLog;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class EmiTagExclusionsLoader
extends SimplePreparableReloadListener<TagExclusions>
implements EmiResourceReloadListener {
    private static final Gson GSON = new Gson();
    private static final ResourceLocation ID = EmiPort.id("emi:tag_exclusions");

    public TagExclusions prepare(ResourceManager manager, ProfilerFiller profiler) {
        TagExclusions exclusions = new TagExclusions();
        for (ResourceLocation id : EmiPort.findResources(manager, "tag/exclusions", i -> i.endsWith(".json"))) {
            if (!id.m_135827_().equals("emi")) continue;
            try {
                for (Resource resource : manager.m_213829_(id)) {
                    InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream(resource));
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    try {
                        if (GsonHelper.m_13855_((JsonObject)json, (String)"replace", (boolean)false)) {
                            exclusions.clear();
                        }
                        for (String key : json.keySet()) {
                            ResourceLocation type = EmiPort.id(key);
                            if (!GsonHelper.m_13885_((JsonObject)json, (String)key)) continue;
                            JsonArray arr = GsonHelper.m_13933_((JsonObject)json, (String)key);
                            for (JsonElement el : arr) {
                                ResourceLocation eid = EmiPort.id(el.getAsString());
                                if (key.equals("exclusions")) {
                                    exclusions.add(eid);
                                    if (!eid.m_135827_().equals("c")) continue;
                                    exclusions.add(EmiPort.id("forge", eid.m_135815_()));
                                    continue;
                                }
                                exclusions.add(type, eid);
                                if (!eid.m_135827_().equals("c")) continue;
                                exclusions.add(type, EmiPort.id("forge", eid.m_135815_()));
                            }
                        }
                    }
                    catch (Exception e) {
                        EmiLog.error("Error loading tag exclusions", e);
                    }
                }
            }
            catch (Exception e) {
                EmiLog.error("Error loading tag exclusions", e);
            }
        }
        return exclusions;
    }

    public void apply(TagExclusions exclusions, ResourceManager manager, ProfilerFiller profiler) {
        EmiTags.exclusions = exclusions;
    }

    @Override
    public ResourceLocation getEmiId() {
        return ID;
    }
}

