/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.handler;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class InventoryRecipeHandler
implements StandardRecipeHandler<InventoryMenu> {
    public static final Component TOO_SMALL = EmiPort.translatable("emi.too_small");

    @Override
    public List<Slot> getInputSources(InventoryMenu handler) {
        int invStart;
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 5; ++i) {
            list.add(handler.m_38853_(i));
        }
        for (int i = invStart = 9; i < invStart + 36; ++i) {
            list.add(handler.m_38853_(i));
        }
        return list;
    }

    @Override
    public List<Slot> getCraftingSlots(InventoryMenu handler) {
        ArrayList list = Lists.newArrayList();
        list.add(handler.m_38853_(1));
        list.add(handler.m_38853_(2));
        list.add(null);
        list.add(handler.m_38853_(3));
        list.add(handler.m_38853_(4));
        list.add(null);
        list.add(null);
        list.add(null);
        list.add(null);
        return list;
    }

    @Override
    public List<Slot> getCraftingSlots(EmiRecipe recipe, InventoryMenu handler) {
        if (recipe instanceof EmiCraftingRecipe) {
            EmiCraftingRecipe craf = (EmiCraftingRecipe)recipe;
            if (craf.shapeless) {
                ArrayList list = Lists.newArrayList();
                list.add(handler.m_38853_(1));
                list.add(handler.m_38853_(2));
                list.add(handler.m_38853_(3));
                list.add(handler.m_38853_(4));
                return list;
            }
        }
        return this.getCraftingSlots(handler);
    }

    @Override
    @Nullable
    public Slot getOutputSlot(InventoryMenu handler) {
        return (Slot)handler.f_38839_.get(0);
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree()) {
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe crafting = (EmiCraftingRecipe)recipe;
                return crafting.canFit(2, 2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<InventoryMenu> context) {
        InventoryMenu sh = context.getScreenHandler();
        if (sh instanceof RecipeBookMenu) {
            RecipeBookMenu arsh = (RecipeBookMenu)sh;
            if (recipe instanceof EmiCraftingRecipe) {
                EmiCraftingRecipe crafting = (EmiCraftingRecipe)recipe;
                return crafting.canFit(arsh.m_6635_(), arsh.m_6656_()) && StandardRecipeHandler.super.canCraft(recipe, context);
            }
        }
        return false;
    }

    @Override
    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<InventoryMenu> context) {
        InventoryMenu sh;
        if (!this.canCraft(recipe, context) && (sh = context.getScreenHandler()) instanceof RecipeBookMenu) {
            EmiCraftingRecipe crafting;
            RecipeBookMenu arsh = (RecipeBookMenu)sh;
            if (recipe instanceof EmiCraftingRecipe && !(crafting = (EmiCraftingRecipe)recipe).canFit(arsh.m_6635_(), arsh.m_6656_())) {
                return List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered(TOO_SMALL)));
            }
        }
        return StandardRecipeHandler.super.getTooltip(recipe, context);
    }
}

