/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.mixinsupport;

import com.google.common.collect.Maps;
import dev.emi.emi.mixinsupport.EmiMixinTransformation;
import dev.emi.emi.mixinsupport.MixinPlaceholder;
import dev.emi.emi.mixinsupport.annotation.AdditionalField;
import dev.emi.emi.mixinsupport.annotation.Extends;
import dev.emi.emi.mixinsupport.annotation.InvokeTarget;
import dev.emi.emi.mixinsupport.annotation.StripConstructors;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.Annotations;

public class EmiMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PLACEHOLDER = MixinPlaceholder.class.getName().replace(".", "/");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        this.processClassAnnotations(targetClassName, targetClass, mixinClassName, mixinInfo);
        EmiMixinTransformation.relinkTransforms(targetClass);
        this.processMethodAnnotations(targetClassName, targetClass, mixinClassName, mixinInfo);
    }

    private void processClassAnnotations(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        AnnotationNode stripConstructors;
        EmiMixinTransformation.applyTransform(targetClass);
        AnnotationNode extendsAnnot = Annotations.getInvisible((ClassNode)targetClass, Extends.class);
        if (extendsAnnot != null) {
            targetClass.superName = (String)Annotations.getValue((AnnotationNode)extendsAnnot, (String)"value", (Object)targetClass.superName);
        }
        if ((stripConstructors = Annotations.getInvisible((ClassNode)targetClass, StripConstructors.class)) != null) {
            for (int i = 0; i < targetClass.methods.size(); ++i) {
                if (!((MethodNode)targetClass.methods.get((int)i)).name.equals("<init>")) continue;
                targetClass.methods.remove(i--);
            }
        }
    }

    private void processMethodAnnotations(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        String thisOwner = targetClassName.replace(".", "/");
        ClassNode mixinClass = mixinInfo.getClassNode(0);
        HashMap targets = Maps.newHashMap();
        for (MethodNode method : mixinClass.methods) {
            AnnotationNode additionalField;
            AnnotationNode invokeTarget = Annotations.getInvisible((MethodNode)method, InvokeTarget.class);
            if (invokeTarget != null) {
                String owner;
                owner = switch (owner = (String)Annotations.getValue((AnnotationNode)invokeTarget, (String)"owner", (Object)targetClassName)) {
                    case "this" -> thisOwner;
                    case "super" -> targetClass.superName;
                    default -> owner;
                };
                String name = (String)Annotations.getValue((AnnotationNode)invokeTarget, (String)"name", (Object)method.name);
                String desc = (String)Annotations.getValue((AnnotationNode)invokeTarget, (String)"desc", (Object)method.desc);
                int type = switch ((String)Annotations.getValue((AnnotationNode)invokeTarget, (String)"type", (Object)"")) {
                    case "VIRTUAL" -> 182;
                    case "SPECIAL" -> 183;
                    case "STATIC" -> 184;
                    case "INTERFACE" -> 185;
                    case "NEW" -> 187;
                    default -> -1;
                };
                targets.put(method.name + method.desc, new InvokeTargetInfo(owner, name, type, desc));
            }
            if ((additionalField = Annotations.getInvisible((MethodNode)method, AdditionalField.class)) == null) continue;
            String value = (String)Annotations.getValue((AnnotationNode)additionalField, (String)"value", (Object)"");
            String ret = method.desc.split("\\)")[1];
            targetClass.fields.add(new FieldNode(25, value, ret, null, null));
            MethodNode clinit = null;
            for (MethodNode mn : targetClass.methods) {
                if (!"<clinit>".equals(mn.name)) continue;
                clinit = mn;
            }
            if (clinit == null) {
                clinit = new MethodNode(8, "<clinit>", "()V", null, null);
                clinit.instructions.add((AbstractInsnNode)new LabelNode());
                clinit.instructions.add((AbstractInsnNode)new InsnNode(177));
                targetClass.methods.add(clinit);
            }
            clinit.instructions.insertBefore(clinit.instructions.getLast(), (AbstractInsnNode)new FieldInsnNode(178, (String)Annotations.getValue((AnnotationNode)additionalField, (String)"owner", (Object)""), (String)Annotations.getValue((AnnotationNode)additionalField, (String)"name", (Object)""), ret));
            clinit.instructions.insertBefore(clinit.instructions.getLast(), (AbstractInsnNode)new FieldInsnNode(179, thisOwner, value, ret));
        }
        for (int i = 0; i < targetClass.methods.size(); ++i) {
            MethodNode method;
            method = (MethodNode)targetClass.methods.get(i);
            if (Annotations.getInvisible((MethodNode)method, InvokeTarget.class) == null && Annotations.getInvisible((MethodNode)method, AdditionalField.class) == null) continue;
            targetClass.methods.remove(i--);
        }
        for (MethodNode method : targetClass.methods) {
            FieldInsnNode lastNewDup = null;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                if (node instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)node;
                    if (thisOwner.equals(min.owner)) {
                        String desc = min.name + min.desc;
                        if (!targets.containsKey(desc)) continue;
                        InvokeTargetInfo info = (InvokeTargetInfo)targets.get(desc);
                        int type = info.type;
                        if (type == -1) {
                            type = info.name.equals("<init>") ? 183 : min.getOpcode();
                        }
                        if (type == 187) {
                            if (lastNewDup != null) {
                                method.instructions.insertBefore((AbstractInsnNode)lastNewDup, (AbstractInsnNode)new TypeInsnNode(187, info.owner));
                                method.instructions.insertBefore((AbstractInsnNode)lastNewDup, (AbstractInsnNode)new InsnNode(89));
                                method.instructions.remove((AbstractInsnNode)lastNewDup);
                                lastNewDup = null;
                                i += 2;
                            }
                            type = 183;
                        }
                        method.instructions.set((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(type, info.owner, info.name, info.desc));
                        if (!info.name.equals("<init>")) continue;
                    }
                }
                if (!(node instanceof FieldInsnNode)) continue;
                FieldInsnNode field = (FieldInsnNode)node;
                if (!MIXIN_PLACEHOLDER.equals(field.owner) || !field.name.equals("NEW_DUP")) continue;
                lastNewDup = field;
            }
        }
    }

    private record InvokeTargetInfo(String owner, String name, int type, String desc) {
    }
}

