/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_core.client.screens;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import net.lyivx.ls_core.LYIVXsCore;
import net.lyivx.ls_core.client.screens.widgets.CustomOptionsList;
import net.lyivx.ls_core.common.config.ILyivxConfigProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfigScreen
extends OptionsSubScreen {
    private Button doneButton;
    private Button resetButton;
    private static final Component TITLE = Component.m_237115_((String)"config.ls_core.title");
    private List<Button> categoryButtons;
    private CustomOptionsList list;
    private ILyivxConfigProvider currentProvider;
    private final Screen lastScreen;
    private final Options options;
    private int topPadding = 33;

    public ModConfigScreen(Screen lastScreen, Options options, String initialProviderModId) {
        super(lastScreen, options, TITLE);
        this.lastScreen = lastScreen;
        this.options = options;
        this.categoryButtons = new ArrayList<Button>();
        this.currentProvider = this.findProvider(initialProviderModId).orElse(LYIVXsCore.getConfigProviders().isEmpty() ? null : LYIVXsCore.getConfigProviders().get(0));
    }

    private int getCategorySectionWidth() {
        return Math.max(155, this.f_96543_ / 4);
    }

    private Optional<ILyivxConfigProvider> findProvider(String modId) {
        if (modId == null) {
            return Optional.empty();
        }
        return LYIVXsCore.getConfigProviders().stream().filter(p -> modId.equals(p.getModId())).findFirst();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        ILyivxConfigProvider providerBeforeResize = this.currentProvider;
        this.m_169411_((GuiEventListener)this.list);
        this.list = null;
        super.m_6574_(minecraft, width, height);
        int contentWidth = this.f_96543_ - this.getCategorySectionWidth();
        this.list = new CustomOptionsList(this.f_96541_, contentWidth, this.f_96544_, this.topPadding, this);
        this.list.m_93507_(this.getCategorySectionWidth());
        this.m_7787_((GuiEventListener)this.list);
        this.currentProvider = this.findProvider(providerBeforeResize != null ? providerBeforeResize.getModId() : null).orElse(LYIVXsCore.getConfigProviders().isEmpty() ? null : LYIVXsCore.getConfigProviders().get(0));
        this.switchCategory(this.currentProvider);
    }

    protected void m_7856_() {
        super.m_7856_();
        int categorySectionWidth = this.getCategorySectionWidth();
        int contentWidth = this.f_96543_ - categorySectionWidth;
        this.list = new CustomOptionsList(this.f_96541_, contentWidth, this.f_96544_, this.topPadding, this);
        this.list.m_93507_(categorySectionWidth);
        this.m_7787_((GuiEventListener)this.list);
        this.addOptions();
        this.switchCategory(this.currentProvider);
        this.addFooter();
    }

    protected void addOptions() {
        this.createCategoryButtons();
    }

    private void createCategoryButtons() {
        int categorySectionWidth = this.getCategorySectionWidth();
        int buttonWidth = Math.min(125, categorySectionWidth - 30);
        int buttonHeight = 20;
        int startX = (categorySectionWidth - buttonWidth) / 2;
        int startY = 40;
        int yOffset = 0;
        this.categoryButtons.clear();
        List<ILyivxConfigProvider> providers = LYIVXsCore.getConfigProviders();
        LinkedHashSet<String> seenNames = new LinkedHashSet<String>();
        for (ILyivxConfigProvider provider : providers) {
            String name = provider.getConfigCategoryName();
            if (name == null || !seenNames.add(name)) continue;
            ILyivxConfigProvider currentLoopProvider = provider;
            Button categoryButton = Button.m_253074_((Component)Component.m_237113_((String)provider.getConfigCategoryName()), button -> this.switchCategory(currentLoopProvider)).m_252987_(startX, startY + yOffset, buttonWidth, buttonHeight).m_253136_();
            this.categoryButtons.add((Button)this.m_142416_((GuiEventListener)categoryButton));
            yOffset += buttonHeight + 5;
        }
        this.updateCategoryButtonSelection();
    }

    private void updateCategoryButtonSelection() {
        for (Button button : this.categoryButtons) {
            String buttonText = button.m_6035_().getString();
            boolean isActive = this.currentProvider != null && buttonText.equals(this.currentProvider.getConfigCategoryName());
            button.f_93623_ = !isActive;
        }
    }

    protected void addFooter() {
        int buttonWidth = 150;
        int spacing = 8;
        int y = this.f_96544_ - 27;
        int startX = (this.f_96543_ - (buttonWidth * 2 + spacing)) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"config.ls_core.reset"), button -> this.resetConfig()).m_252987_(startX, y, buttonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.f_96541_.m_91152_(this.lastScreen)).m_252987_(startX + buttonWidth + spacing, y, buttonWidth, 20).m_253136_());
    }

    private void switchCategory(ILyivxConfigProvider provider) {
        this.currentProvider = provider;
        this.list.m_6702_().clear();
        this.list.m_93410_(0.0);
        if (this.currentProvider != null) {
            this.list.addTitle((Component)Component.m_237113_((String)this.currentProvider.getConfigCategoryName()));
            this.currentProvider.addConfigOptions(this, this.list);
        } else {
            this.list.addTitle((Component)Component.m_237113_((String)"No Configuration Available"));
        }
        this.updateCategoryButtonSelection();
    }

    private void resetConfig() {
        if (this.currentProvider != null) {
            LYIVXsCore.LOGGER.info("Resetting config for: {}", (Object)this.currentProvider.getModId());
            this.currentProvider.resetConfigDefaults();
            this.list.m_6702_().clear();
            this.list.m_93410_(0.0);
            this.list.addTitle((Component)Component.m_237113_((String)this.currentProvider.getConfigCategoryName()));
            this.currentProvider.addConfigOptions(this, this.list);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280039_(guiGraphics);
        int categorySectionWidth = this.getCategorySectionWidth();
        int bottomPadding = 33;
        int footerY = this.f_96544_ - 36;
        guiGraphics.m_280509_(categorySectionWidth, this.topPadding, this.f_96543_, footerY, 0x44000000);
        guiGraphics.m_280509_(0, this.topPadding, categorySectionWidth, footerY, 0x44000000);
        this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280509_(categorySectionWidth - 1, this.topPadding, categorySectionWidth, this.f_96544_ - bottomPadding, 0x75000000);
        for (Button button : this.categoryButtons) {
            button.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.list != null) {
            for (CustomOptionsList.Entry entry : this.list.m_6702_()) {
                if (!entry.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.list != null) {
            for (CustomOptionsList.Entry entry : this.list.m_6702_()) {
                if (!entry.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.list != null) {
            for (CustomOptionsList.Entry entry : this.list.m_6702_()) {
                if (!entry.m_6348_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.list != null && this.list.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }
}

