/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_core.client.screens.widgets;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CustomOptionsList
extends ContainerObjectSelectionList<Entry> {
    private static final int DEFAULT_ITEM_HEIGHT = 25;
    private final OptionsSubScreen screen;

    public CustomOptionsList(Minecraft minecraft, int width, int height, int top, OptionsSubScreen screen) {
        super(minecraft, width, height, top, height - 32, 25);
        this.f_93394_ = false;
        this.screen = screen;
    }

    public void addBig(OptionInstance option) {
        this.m_7085_((AbstractSelectionList.Entry)OptionEntry.big(this.f_93386_.f_91066_, option, this.screen));
    }

    public void addSmall(OptionInstance ... options) {
        for (int i = 0; i < options.length; i += 2) {
            OptionInstance option = i < options.length - 1 ? options[i + 1] : null;
            this.m_7085_((AbstractSelectionList.Entry)OptionEntry.small(this.f_93386_.f_91066_, options[i], option, this.screen));
        }
    }

    public void addSmall(List<AbstractWidget> options) {
        for (int i = 0; i < options.size(); i += 2) {
            this.addSmall(options.get(i), i < options.size() - 1 ? options.get(i + 1) : null);
        }
    }

    public void addSmall(AbstractWidget leftOption, @Nullable AbstractWidget rightOption) {
        this.m_7085_((AbstractSelectionList.Entry)Entry.small(leftOption, rightOption, (Screen)this.screen));
    }

    public void addTitle(Component title) {
        this.m_7085_((AbstractSelectionList.Entry)TitleEntry.create(title, (Screen)this.screen));
    }

    public int m_5759_() {
        return (int)((double)this.f_93388_ * 0.9);
    }

    @Nullable
    public AbstractWidget findOption(OptionInstance option) {
        for (Entry entry : this.m_6702_()) {
            if (!(entry instanceof OptionEntry)) continue;
            OptionEntry optionEntry = (OptionEntry)entry;
            AbstractWidget abstractWidget = optionEntry.options.get(option);
            if (abstractWidget == null) continue;
            return abstractWidget;
        }
        return null;
    }

    public Optional<GuiEventListener> getMouseOver(double mouseX, double mouseY) {
        for (Entry entry : this.m_6702_()) {
            for (GuiEventListener guiEventListener : entry.m_6702_()) {
                if (!guiEventListener.m_5953_(mouseX, mouseY)) continue;
                return Optional.of(guiEventListener);
            }
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class OptionEntry
    extends Entry {
        final Map<OptionInstance, AbstractWidget> options;

        private OptionEntry(Map<OptionInstance, AbstractWidget> options, OptionsSubScreen screen) {
            super((List<AbstractWidget>)ImmutableList.copyOf(options.values()), (Screen)screen);
            this.options = options;
        }

        public static OptionEntry big(Options options, OptionInstance<?> option, OptionsSubScreen screen) {
            int width = screen.f_96543_ - 155 - 20;
            return new OptionEntry((Map<OptionInstance, AbstractWidget>)ImmutableMap.of(option, (Object)option.m_231507_(options, 0, 0, width)), screen);
        }

        public static OptionEntry small(Options options, OptionInstance leftOption, @Nullable OptionInstance rightOption, OptionsSubScreen screen) {
            AbstractWidget abstractWidget = leftOption.m_231507_(options, 0, 0, 150);
            return rightOption == null ? new OptionEntry((Map<OptionInstance, AbstractWidget>)ImmutableMap.of((Object)leftOption, (Object)abstractWidget), screen) : new OptionEntry((Map<OptionInstance, AbstractWidget>)ImmutableMap.of((Object)leftOption, (Object)abstractWidget, (Object)rightOption, (Object)rightOption.m_231507_(options, 0, 0, 150)), screen);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final List<AbstractWidget> children;
        private final Screen screen;
        protected final Minecraft minecraft = Minecraft.m_91087_();
        private static final int X_OFFSET = 160;

        Entry(List<AbstractWidget> children, Screen screen) {
            this.children = ImmutableList.copyOf(children);
            this.screen = screen;
        }

        public static Entry big(List<AbstractWidget> options, Screen screen) {
            return new Entry(options, screen);
        }

        public static Entry small(AbstractWidget leftOption, @Nullable AbstractWidget rightOption, Screen screen) {
            return rightOption == null ? new Entry((List<AbstractWidget>)ImmutableList.of((Object)leftOption), screen) : new Entry((List<AbstractWidget>)ImmutableList.of((Object)leftOption, (Object)rightOption), screen);
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int totalWidth = width - 20;
            int widgetWidth = this.children.size() > 1 ? totalWidth / 2 - 10 : totalWidth;
            int x = left + 10;
            for (AbstractWidget widget : this.children) {
                widget.m_93674_(widgetWidth);
                widget.m_264152_(x, top + 3);
                widget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                x += widgetWidth + 20;
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class TitleEntry
    extends Entry {
        private final Component title;

        private TitleEntry(Component title, Screen screen) {
            super((List<AbstractWidget>)ImmutableList.of(), screen);
            this.title = title;
        }

        public static TitleEntry create(Component title, Screen screen) {
            return new TitleEntry(title, screen);
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.title);
            int x = left + (width - textWidth) / 2;
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, this.title, x, top + 5, 0xFFFFFF);
        }
    }
}

