/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_core.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CustomConfigSpec {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private JsonObject config;
    private final Path configPath;
    private final JsonObject defaultConfig;

    public CustomConfigSpec(Path configDirectory, String providerModId, JsonObject defaultConfig) {
        this.defaultConfig = defaultConfig != null ? defaultConfig : new JsonObject();
        this.config = new JsonObject();
        this.configPath = configDirectory.resolve(providerModId + ".json");
        System.out.println("Config for [" + providerModId + "] will be saved to: " + String.valueOf(this.configPath.toAbsolutePath()));
        this.loadOrCreateConfig();
    }

    private void loadOrCreateConfig() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            this.loadConfig();
            this.mergeDefaults();
        } else {
            this.config = this.defaultConfig.deepCopy();
            this.saveConfig();
        }
    }

    private void mergeDefaults() {
        boolean changed = false;
        for (String key : this.defaultConfig.keySet()) {
            if (this.config.has(key)) continue;
            this.config.add(key, this.defaultConfig.get(key));
            changed = true;
        }
        if (changed) {
            this.saveConfig();
        }
    }

    public void loadConfig() {
        try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
            this.config = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                this.gson.toJson((JsonElement)this.config, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsonObject getConfigRoot() {
        return this.config;
    }

    public JsonElement get(String key) {
        return this.config.get(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.config.has(key) && this.config.get(key).isJsonPrimitive() && this.config.get(key).getAsJsonPrimitive().isBoolean()) {
            return this.config.get(key).getAsBoolean();
        }
        this.setBoolean(key, defaultValue);
        return defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        if (this.config.has(key) && this.config.get(key).isJsonPrimitive() && this.config.get(key).getAsJsonPrimitive().isNumber()) {
            return this.config.get(key).getAsInt();
        }
        this.setInt(key, defaultValue);
        return defaultValue;
    }

    public String getString(String key, String defaultValue) {
        if (this.config.has(key) && this.config.get(key).isJsonPrimitive() && this.config.get(key).getAsJsonPrimitive().isString()) {
            return this.config.get(key).getAsString();
        }
        this.setString(key, defaultValue);
        return defaultValue;
    }

    public <T extends Enum<T>> T getEnum(String key, T defaultValue, Class<T> enumClass) {
        if (this.config.has(key) && this.config.get(key).isJsonPrimitive() && this.config.get(key).getAsJsonPrimitive().isString()) {
            try {
                return Enum.valueOf(enumClass, this.config.get(key).getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.setEnum(key, defaultValue);
        return defaultValue;
    }

    public void set(String key, JsonElement value) {
        this.config.add(key, value);
        this.saveConfig();
    }

    public void setBoolean(String key, boolean value) {
        this.config.addProperty(key, Boolean.valueOf(value));
        this.saveConfig();
    }

    public void setInt(String key, int value) {
        this.config.addProperty(key, (Number)value);
        this.saveConfig();
    }

    public void setString(String key, String value) {
        this.config.addProperty(key, value);
        this.saveConfig();
    }

    public <T extends Enum<T>> void setEnum(String key, T value) {
        this.config.addProperty(key, value.name());
        this.saveConfig();
    }
}

