/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.client.KeyBindings;
import com.direwolf20.buildinggadgets2.client.OurSounds;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.client.screen.CopyGUI;
import com.direwolf20.buildinggadgets2.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets2.client.screen.PasteGUI;
import com.direwolf20.buildinggadgets2.client.screen.widgets.GuiIconActionable;
import com.direwolf20.buildinggadgets2.client.screen.widgets.IncrementalSliderWidget;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketAnchor;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketCut;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketModeSwitch;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketRangeChange;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketRenderChange;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketRotate;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketToggleSetting;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketUndo;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeI18n;
import org.joml.Matrix4f;

public class ModeRadialMenu
extends Screen {
    private static final ImmutableList<ResourceLocation> signsCopyPaste = ImmutableList.of((Object)new ResourceLocation("buildinggadgets2", "textures/gui/mode/copy.png"), (Object)new ResourceLocation("buildinggadgets2", "textures/gui/mode/paste.png"));
    private final List<Button> conditionalButtons = new ArrayList<Button>();
    private int timeIn = 0;
    private int slotSelected = -1;
    private int segments;
    private ArrayList<BaseMode> arrayOfModes = new ArrayList();
    private boolean cutForSure = false;
    private BaseMode mode;
    private Button renderTypeButton;
    private GadgetNBT.RenderTypes renderType;

    public ModeRadialMenu(ItemStack stack) {
        super((Component)Component.m_237113_((String)""));
        if (stack.m_41720_() instanceof BaseGadget) {
            this.setSocketable(stack);
        }
        this.mode = GadgetNBT.getMode(stack);
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f(mx - x, my - y);
        float ang = (float)(Math.acos(baseVec.dot(mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }

    public void setSocketable(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BaseGadget) {
            BaseGadget actualGadget = (BaseGadget)item;
            this.segments = GadgetModes.INSTANCE.getModesForGadget(actualGadget.gadgetTarget()).size();
        }
    }

    public void m_7856_() {
        ItemStack tool = this.getGadget();
        this.renderType = GadgetNBT.getRenderType(tool);
        Item item = tool.m_41720_();
        if (!(item instanceof BaseGadget)) {
            return;
        }
        BaseGadget actualGadget = (BaseGadget)item;
        ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(actualGadget.gadgetTarget());
        this.arrayOfModes = new ArrayList<BaseMode>((Collection<BaseMode>)modesForGadget);
        this.conditionalButtons.clear();
        PositionedIconActionable rayTrace = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.raytracefluids"), "raytrace_fluid", ScreenPosition.RIGHT, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketToggleSetting("raytracefluid"));
            }
            return GadgetNBT.getSetting(tool, "raytracefluid");
        });
        this.m_142416_((GuiEventListener)rayTrace);
        if (tool.m_41720_() instanceof GadgetBuilding) {
            PositionedIconActionable placeOnTop = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.screen.placeatop"), "building_place_atop", ScreenPosition.RIGHT, true, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleSetting("placeontop"));
                }
                return GadgetNBT.getSetting(tool, "placeontop");
            });
            this.m_142416_((GuiEventListener)placeOnTop);
        }
        if (tool.m_41720_() instanceof GadgetBuilding || tool.m_41720_() instanceof GadgetExchanger) {
            int widthSlider = 82;
            IncrementalSliderWidget sliderRange = new IncrementalSliderWidget(this.f_96543_ / 2 - widthSlider / 2, this.f_96544_ / 2 + 72, widthSlider, 14, 1.0, 15.0, (Component)Component.m_237115_((String)"buildinggadgets2.gui.range").m_130946_(": "), GadgetNBT.getToolRange(tool), slider -> this.sendRangeUpdate(slider.getValueInt()));
            sliderRange.getComponents().forEach(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
            });
        }
        if (tool.m_41720_() instanceof GadgetExchanger) {
            PositionedIconActionable affectTiles = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.screen.affecttiles"), "affecttiles", ScreenPosition.RIGHT, true, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleSetting("affecttiles"));
                }
                return GadgetNBT.getSetting(tool, "affecttiles");
            });
            this.m_142416_((GuiEventListener)affectTiles);
        }
        if (tool.m_41720_() instanceof GadgetCutPaste) {
            this.m_142416_((GuiEventListener)new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.cut"), "cut", ScreenPosition.LEFT, false, send -> {
                if (send.booleanValue()) {
                    if (GadgetNBT.hasCopyUUID(tool) && !this.cutForSure) {
                        this.getMinecraft().f_91074_.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.overwritecut"), true);
                        this.cutForSure = true;
                        return false;
                    }
                    PacketHandler.sendToServer(new PacketCut());
                    int modeIndex = this.arrayOfModes.indexOf(this.mode);
                    modeIndex = modeIndex == 0 ? 1 : 0;
                    PacketHandler.sendToServer(new PacketModeSwitch(this.arrayOfModes.get(modeIndex).getId(), false));
                    this.mode = this.arrayOfModes.get(modeIndex);
                }
                return false;
            }));
        }
        if (tool.m_41720_() instanceof GadgetCopyPaste) {
            PositionedIconActionable materialList = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.materiallist"), "copypaste_materiallist", ScreenPosition.RIGHT, false, send -> {
                if (send.booleanValue()) {
                    BaseMode mode = GadgetNBT.getMode(tool);
                    if (GadgetNBT.hasCopyUUID(tool) && mode.getId().m_135815_().equals("paste")) {
                        this.getMinecraft().m_91152_((Screen)new MaterialListGUI(tool));
                    }
                }
                return false;
            });
            this.m_142416_((GuiEventListener)materialList);
            this.conditionalButtons.add(materialList);
        }
        if (tool.m_41720_() instanceof GadgetCutPaste || tool.m_41720_() instanceof GadgetCopyPaste) {
            PositionedIconActionable pastereplace = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.screen.paste_replace"), "paste_replace", ScreenPosition.RIGHT, true, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleSetting("pastereplace"));
                }
                return GadgetNBT.getPasteReplace(tool);
            });
            this.m_142416_((GuiEventListener)pastereplace);
            this.m_142416_((GuiEventListener)new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.copypastemenu"), "copypaste_opengui", ScreenPosition.RIGHT, false, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                assert (this.getMinecraft().f_91074_ != null);
                this.getMinecraft().f_91074_.m_6915_();
                if (this.mode.getId().m_135815_().equals("paste")) {
                    this.getMinecraft().m_91152_((Screen)new PasteGUI(tool));
                } else {
                    this.getMinecraft().m_91152_((Screen)new CopyGUI(tool));
                }
                return true;
            }));
            this.m_142416_((GuiEventListener)new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.rotate"), "rotate", ScreenPosition.LEFT, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketRotate());
                }
                return false;
            }));
        }
        if (!(tool.m_41720_() instanceof GadgetCutPaste)) {
            PositionedIconActionable undo_button = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.undo"), "undo", ScreenPosition.LEFT, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketUndo());
                }
                return false;
            });
            this.m_142416_((GuiEventListener)undo_button);
            PositionedIconActionable bind_button = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.bind"), "building_place_atop", ScreenPosition.LEFT, true, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleSetting("bind"));
                }
                return GadgetNBT.getSetting(tool, "bind");
            });
            this.m_142416_((GuiEventListener)bind_button);
        }
        PositionedIconActionable fuzzy_button = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.fuzzy"), "fuzzy", ScreenPosition.RIGHT, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketToggleSetting(GadgetNBT.NBTValues.FUZZY.value));
            }
            return GadgetNBT.getSetting(this.getGadget(), GadgetNBT.NBTValues.FUZZY.value);
        });
        this.m_142416_((GuiEventListener)fuzzy_button);
        this.conditionalButtons.add(fuzzy_button);
        PositionedIconActionable connected_button = new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.connected_area"), "connected_area", ScreenPosition.RIGHT, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketToggleSetting(GadgetNBT.NBTValues.CONNECTED_AREA.value));
            }
            return GadgetNBT.getSetting(this.getGadget(), GadgetNBT.NBTValues.CONNECTED_AREA.value);
        });
        this.m_142416_((GuiEventListener)connected_button);
        this.conditionalButtons.add(connected_button);
        this.m_142416_((GuiEventListener)new PositionedIconActionable((Component)Component.m_237115_((String)"buildinggadgets2.radialmenu.anchor"), "anchor", ScreenPosition.LEFT, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketAnchor());
            }
            return !GadgetNBT.getAnchorPos(tool).equals((Object)GadgetNBT.nullPos);
        }));
        this.renderTypeButton = new PositionedIconActionable((Component)Component.m_237115_((String)this.renderType.getLang()), "raytrace_fluid", ScreenPosition.LEFT, false, send -> {
            if (send.booleanValue()) {
                this.renderType = this.renderType.next();
                this.renderTypeButton.m_93666_((Component)Component.m_237115_((String)this.renderType.getLang()));
                PacketHandler.sendToServer(new PacketRenderChange(this.renderType.getPosition()));
            }
            return false;
        });
        this.m_142416_((GuiEventListener)this.renderTypeButton);
        this.updateButtons();
    }

    private void updateButtons() {
        int buttonSize = 24;
        int paddingBetweenButtonsY = 10;
        int yPosLeft = this.f_96544_ / 4;
        int yPosRight = this.f_96544_ / 4;
        for (GuiEventListener widget : this.m_6702_()) {
            int xPos;
            if (!(widget instanceof PositionedIconActionable)) continue;
            PositionedIconActionable button = (PositionedIconActionable)widget;
            if (!button.f_93624_) continue;
            if (button.position == ScreenPosition.RIGHT) {
                xPos = this.f_96543_ / 2 + 70;
                yPosRight = yPosRight + paddingBetweenButtonsY + buttonSize;
                button.m_93674_(buttonSize);
                button.setHeight(buttonSize);
                button.m_252865_(xPos);
                button.m_253211_(yPosRight);
                continue;
            }
            if (button.position != ScreenPosition.LEFT) continue;
            xPos = this.f_96543_ / 2 - 70 - buttonSize;
            yPosLeft = yPosLeft + paddingBetweenButtonsY + buttonSize;
            button.m_93674_(buttonSize);
            button.setHeight(buttonSize);
            button.m_252865_(xPos);
            button.m_253211_(yPosLeft);
        }
    }

    private ItemStack getGadget() {
        assert (this.getMinecraft().f_91074_ != null);
        return BaseGadget.getGadget((Player)this.getMinecraft().f_91074_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        PoseStack matrices = guiGraphics.m_280168_();
        float speedOfButtonGrowth = 7.0f;
        float fract = Math.min(speedOfButtonGrowth, (float)this.timeIn + partialTicks) / speedOfButtonGrowth;
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        int radiusMin = 26;
        int radiusMax = 60;
        double dist = new Vec3((double)x, (double)y, 0.0).m_82554_(new Vec3((double)mx, (double)my, 0.0));
        boolean inRange = false;
        if (this.segments != 0) {
            inRange = dist > (double)radiusMin && dist < (double)radiusMax;
            for (GuiEventListener button : this.m_6702_()) {
                if (!(button instanceof PositionedIconActionable)) continue;
                ((PositionedIconActionable)button).setFaded(inRange);
            }
        }
        matrices.m_85836_();
        matrices.m_252880_((1.0f - fract) * (float)x, (1.0f - fract) * (float)y, 0.0f);
        matrices.m_85841_(fract, fract, fract);
        super.m_88315_(guiGraphics, mx, my, partialTicks);
        matrices.m_85849_();
        if (this.segments == 0) {
            return;
        }
        float angle = ModeRadialMenu.mouseAngle(x, y, mx, my);
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)this.segments;
        ArrayList<NameDisplayData> nameData = new ArrayList<NameDisplayData>();
        ItemStack tool = this.getGadget();
        if (tool.m_41619_()) {
            return;
        }
        this.slotSelected = -1;
        int modeIndex = this.arrayOfModes.indexOf(this.mode);
        boolean shouldCenter = (this.segments + 2) % 4 == 0;
        int indexBottom = this.segments / 4;
        int indexTop = indexBottom + this.segments / 2;
        for (int seg = 0; seg < this.segments; ++seg) {
            boolean mouseInSector = this.isCursorInSlice(angle, totalDeg, degPer, inRange);
            float delayBetweenSegments = 1.0f;
            float speedOfSegmentGrowth = 10.0f;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * delayBetweenSegments / (float)this.segments) * speedOfSegmentGrowth, (float)radiusMax));
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs + (seg == modeIndex ? 1.0f : 0.0f);
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer buffer = bufferSource.m_6299_(OurRenderTypes.TRIANGLE_STRIP);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                float xp = (float)((double)x + Math.cos(rad) * (double)radius);
                float yp = (float)((double)y + Math.sin(rad) * (double)radius);
                if ((int)i == (int)(degPer / 2.0f)) {
                    nameData.add(new NameDisplayData((int)xp, (int)yp, mouseInSector, shouldCenter && (seg == indexBottom || seg == indexTop)));
                }
                Matrix4f pose = matrices.m_85850_().m_252922_();
                buffer.m_252986_(pose, (float)((double)x + Math.cos(rad) * (double)radius / (double)2.3f), (float)((double)y + Math.sin(rad) * (double)radius / (double)2.3f), 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_5483_((double)xp, (double)yp, 0.0).m_85950_(r, g, b, a).m_5752_();
            }
            bufferSource.m_109912_(OurRenderTypes.TRIANGLE_STRIP);
            totalDeg += degPer;
        }
        for (int i = 0; i < nameData.size(); ++i) {
            Color color;
            matrices.m_85836_();
            NameDisplayData data = (NameDisplayData)nameData.get(i);
            int xp = data.getX();
            int yp = data.getY();
            String name = ForgeI18n.getPattern((String)this.arrayOfModes.get(i).i18n());
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.f_96547_.m_92895_(name);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            Color color2 = color = i == modeIndex ? Color.GREEN : Color.WHITE;
            if (data.isSelected()) {
                guiGraphics.drawString(this.f_96547_, name, (float)xsp + (data.isCentralized() ? (float)width / 2.0f - 4.0f : 0.0f), (float)ysp, color.getRGB(), true);
            }
            double mod = 0.7;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.mode.icon());
            guiGraphics.m_280163_(this.arrayOfModes.get(i).icon(), xdp - 8, ydp - 8, 0.0f, 0.0f, 16, 16, 16, 16);
            matrices.m_85849_();
        }
        Color color = Color.WHITE;
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        float s = 1.8f * fract;
        matrices.m_85836_();
        matrices.m_85841_(s, s, s);
        matrices.m_85837_((double)((float)x / s) - (tool.m_41720_() instanceof GadgetCopyPaste ? 8.0 : 8.5), (double)((float)y / s - 8.0f), 440.0);
        guiGraphics.m_280480_(tool, 0, 0);
        matrices.m_85849_();
    }

    private boolean isCursorInSlice(float angle, float totalDeg, float degPer, boolean inRange) {
        return inRange && angle > totalDeg && angle < totalDeg + degPer;
    }

    private void changeMode() {
        if (this.slotSelected >= 0) {
            assert (this.getMinecraft().f_91074_ != null);
            PacketHandler.sendToServer(new PacketModeSwitch(this.arrayOfModes.get(this.slotSelected).getId(), false));
            this.mode = this.arrayOfModes.get(this.slotSelected);
            OurSounds.playSound((SoundEvent)Registration.BEEP.get());
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.changeMode();
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_86600_() {
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)KeyBindings.menuSettings.getKey().m_84873_())) {
            this.m_7379_();
            this.changeMode();
        }
        ImmutableSet set = ImmutableSet.of((Object)this.getMinecraft().f_91066_.f_92085_, (Object)this.getMinecraft().f_91066_.f_92086_, (Object)this.getMinecraft().f_91066_.f_92087_, (Object)this.getMinecraft().f_91066_.f_92088_, (Object)this.getMinecraft().f_91066_.f_92090_, (Object)this.getMinecraft().f_91066_.f_92091_, (Object[])new KeyMapping[]{this.getMinecraft().f_91066_.f_92089_});
        for (KeyMapping k : set) {
            KeyMapping.m_90837_((InputConstants.Key)k.getKey(), (boolean)k.m_90857_());
        }
        ++this.timeIn;
        ItemStack tool = this.getGadget();
        boolean showButton = true;
        boolean changed = false;
        for (Button button : this.conditionalButtons) {
            if (button.m_6035_().equals(Component.m_237115_((String)"buildinggadgets2.radialmenu.fuzzy")) || button.m_6035_().equals(Component.m_237115_((String)"buildinggadgets2.radialmenu.connected_area"))) {
                showButton = tool.m_41720_() instanceof GadgetBuilding ? this.mode.getId().m_135815_().equals("surface") : tool.m_41720_() instanceof GadgetExchanger;
            } else if (button.m_6035_().equals(Component.m_237115_((String)"buildinggadgets2.radialmenu.materiallist"))) {
                showButton = this.mode.getId().m_135815_().equals("paste");
            }
            if (button.f_93624_ == showButton) continue;
            button.f_93624_ = showButton;
            changed = true;
        }
        if (changed) {
            this.updateButtons();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void sendRangeUpdate(int valueNew) {
        if (valueNew != GadgetNBT.getToolRange(this.getGadget())) {
            PacketHandler.sendToServer(new PacketRangeChange(valueNew));
        }
    }

    private static class Vector2f {
        public float x;
        public float y;

        public Vector2f(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float dot(Vector2f v1) {
            return this.x * v1.x + this.y * v1.y;
        }

        public final float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }

    private static class PositionedIconActionable
    extends GuiIconActionable {
        private ScreenPosition position;

        PositionedIconActionable(Component message, String icon, ScreenPosition position, boolean isSelectable, Predicate<Boolean> action) {
            super(0, 0, icon, message, isSelectable, action);
            this.position = position;
        }

        PositionedIconActionable(Component message, String icon, ScreenPosition position, Predicate<Boolean> action) {
            this(message, icon, position, true, action);
        }
    }

    public static enum ScreenPosition {
        RIGHT,
        LEFT,
        BOTTOM,
        TOP;

    }

    private static final class NameDisplayData {
        private final int x;
        private final int y;
        private final boolean selected;
        private final boolean centralize;

        private NameDisplayData(int x, int y, boolean selected, boolean centralize) {
            this.x = x;
            this.y = y;
            this.selected = selected;
            this.centralize = centralize;
        }

        private int getX() {
            return this.x;
        }

        private int getY() {
            return this.y;
        }

        private boolean isSelected() {
            return this.selected;
        }

        private boolean isCentralized() {
            return this.centralize;
        }
    }
}

