/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.WitherRoseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.apache.commons.lang3.NotImplementedException;
import snownee.kiwi.customization.block.BasicBlock;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.loader.InjectedBlockPropertiesCodec;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.util.codec.CustomizationCodecs;

public class BlockCodecs {
    private static final Map<ResourceLocation, MapCodec<Block>> CODECS = Maps.newHashMap();
    public static final String BLOCK_PROPERTIES_KEY = "properties";
    private static final Codec<BlockBehaviour.Properties> BLOCK_PROPERTIES = new InjectedBlockPropertiesCodec((Codec<BlockBehaviour.Properties>)Codec.unit(BlockBehaviour.Properties::m_284310_));
    public static final Function<BlockBehaviour.Properties, Block> SIMPLE_BLOCK_FACTORY = properties -> {
        KBlockSettings settings = ((KBlockProperties)properties).kiwi$getSettings();
        if (settings != null && settings.hasComponent(KBlockComponents.WATER_LOGGABLE.getOrCreate())) {
            return new BasicBlock((BlockBehaviour.Properties)properties);
        }
        return new Block(properties);
    };
    public static final MapCodec<Block> BLOCK = BlockCodecs.simpleCodec(SIMPLE_BLOCK_FACTORY);
    public static final MapCodec<StairBlock> STAIR = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.f_61039_.optionalFieldOf("base_state", (Object)Blocks.f_50016_.m_49966_()).forGetter(block -> {
        throw new UnsupportedOperationException();
    }), BlockCodecs.propertiesCodec()).apply((Applicative)instance, StairBlock::new));
    public static final MapCodec<DoorBlock> DOOR = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(DoorBlock::m_278711_)).apply((Applicative)instance, DoorBlock::new));
    public static final MapCodec<TrapDoorBlock> TRAPDOOR = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(block -> block.f_271458_)).apply((Applicative)instance, TrapDoorBlock::new));
    public static final MapCodec<FenceGateBlock> FENCE_GATE = BlockCodecs.woodTyped(FenceGateBlock::new);
    public static final MapCodec<SandBlock> SAND = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("falling_dust_color", (Object)14406560).forGetter($ -> 14406560), BlockCodecs.propertiesCodec()).apply((Applicative)instance, SandBlock::new));
    public static final MapCodec<DropExperienceBlock> DROP_EXPERIENCE = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)IntProvider.f_146532_.fieldOf("xp").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, DropExperienceBlock::new));
    public static final MapCodec<MushroomBlock> MUSHROOM = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256911_).fieldOf("feature").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, MushroomBlock::new));
    public static final MapCodec<FlowerBlock> FLOWER = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("suspicious_stew_effect").forGetter(FlowerBlock::m_53521_), (App)ExtraCodecs.f_144629_.fieldOf("effect_duration").forGetter(FlowerBlock::m_53522_), BlockCodecs.propertiesCodec()).apply((Applicative)instance, FlowerBlock::new));
    public static final MapCodec<FlowerPotBlock> FLOWER_POT = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("content").forGetter(FlowerPotBlock::m_53560_), BlockCodecs.propertiesCodec()).apply((Applicative)instance, FlowerPotBlock::new));
    public static final MapCodec<WitherRoseBlock> WITHER_ROSE = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("effect").forGetter(FlowerBlock::m_53521_), BlockCodecs.propertiesCodec()).apply((Applicative)instance, WitherRoseBlock::new));
    public static final MapCodec<ButtonBlock> BUTTON = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(BlockCodecs::notImplemented), (App)ExtraCodecs.f_144629_.optionalFieldOf("ticks_to_stay_pressed").forGetter(BlockCodecs::notImplemented), (App)Codec.BOOL.optionalFieldOf("arrows_can_press").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, (properties, blockSetType, ticksToStayPressed, arrowsCanPress) -> new ButtonBlock(properties, blockSetType, ticksToStayPressed.orElse(blockSetType.f_278463_() ? 30 : 20).intValue(), arrowsCanPress.orElse(blockSetType.f_278463_()).booleanValue())));
    public static final MapCodec<PressurePlateBlock> PRESSURE_PLATE = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.SENSITIVITY_CODEC.optionalFieldOf("sensitivity").forGetter(BlockCodecs::notImplemented), BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, (sensitivity, properties, blockSetType) -> new PressurePlateBlock(sensitivity.orElse(blockSetType.f_278463_() ? PressurePlateBlock.Sensitivity.EVERYTHING : PressurePlateBlock.Sensitivity.MOBS), properties, blockSetType)));
    public static final MapCodec<WeatheringCopperFullBlock> WEATHERING_COPPER_FULL = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.WEATHER_STATE.fieldOf("weather_state").forGetter(ChangeOverTimeBlock::m_142297_), BlockCodecs.propertiesCodec()).apply((Applicative)instance, WeatheringCopperFullBlock::new));
    public static final MapCodec<WeatheringCopperSlabBlock> WEATHERING_COPPER_SLAB = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.WEATHER_STATE.fieldOf("weather_state").forGetter(ChangeOverTimeBlock::m_142297_), BlockCodecs.propertiesCodec()).apply((Applicative)instance, WeatheringCopperSlabBlock::new));
    public static final MapCodec<WeatheringCopperStairBlock> WEATHERING_COPPER_STAIR = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.WEATHER_STATE.fieldOf("weather_state").forGetter(ChangeOverTimeBlock::m_142297_), (App)BlockState.f_61039_.fieldOf("base_state").forGetter($ -> {
        throw new UnsupportedOperationException();
    }), BlockCodecs.propertiesCodec()).apply((Applicative)instance, WeatheringCopperStairBlock::new));
    public static final MapCodec<BedBlock> BED = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.f_262211_.fieldOf("color").forGetter(BedBlock::m_49554_), BlockCodecs.propertiesCodec()).apply((Applicative)instance, BedBlock::new));
    public static final MapCodec<BrushableBlock> BRUSHABLE = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("turns_into").forGetter(BrushableBlock::m_277074_), BlockCodecs.propertiesCodec(), (App)BuiltInRegistries.f_256894_.m_194605_().optionalFieldOf("brush_sound", (Object)SoundEvents.f_271174_).forGetter(BrushableBlock::m_276856_), (App)BuiltInRegistries.f_256894_.m_194605_().optionalFieldOf("brush_completed_sound", (Object)SoundEvents.f_271452_).forGetter(BrushableBlock::m_277154_)).apply((Applicative)instance, BrushableBlock::new));
    public static final MapCodec<WallSignBlock> WALL_SIGN = BlockCodecs.woodTyped(WallSignBlock::new);
    public static final MapCodec<StandingSignBlock> STANDING_SIGN = BlockCodecs.woodTyped(StandingSignBlock::new);
    public static final MapCodec<WallHangingSignBlock> WALL_HANGING_SIGN = BlockCodecs.woodTyped(WallHangingSignBlock::new);
    public static final MapCodec<CeilingHangingSignBlock> CEILING_HANGING_SIGN = BlockCodecs.woodTyped(CeilingHangingSignBlock::new);

    public static <B extends Block> RecordCodecBuilder<B, BlockBehaviour.Properties> propertiesCodec() {
        return BLOCK_PROPERTIES.fieldOf(BLOCK_PROPERTIES_KEY).forGetter(block -> block.f_60439_);
    }

    public static <B extends Block> MapCodec<B> simpleCodec(Function<BlockBehaviour.Properties, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec()).apply((Applicative)instance, function));
    }

    public static void register(String key, MapCodec<? extends Block> codec) {
        BlockCodecs.register(new ResourceLocation("minecraft", key), codec);
    }

    public static void register(ResourceLocation key, MapCodec<? extends Block> codec) {
        CODECS.put(key, codec);
    }

    public static MapCodec<Block> get(ResourceLocation key) {
        return Objects.requireNonNull(CODECS.get(key), () -> ((ResourceLocation)key).toString());
    }

    public static <O, A> A notImplemented(O block) {
        throw new NotImplementedException();
    }

    public static <T extends Block> MapCodec<T> woodTyped(BiFunction<BlockBehaviour.Properties, WoodType, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.WOOD_TYPE.optionalFieldOf("wood_type", (Object)WoodType.f_61830_).forGetter($ -> WoodType.f_61830_)).apply((Applicative)instance, factory));
    }

    static {
        BlockCodecs.register("block", BLOCK);
        BlockCodecs.register("stair", STAIR);
        BlockCodecs.register("door", DOOR);
        BlockCodecs.register("trapdoor", TRAPDOOR);
        BlockCodecs.register("fence_gate", FENCE_GATE);
        BlockCodecs.register("colored_falling", SAND);
        BlockCodecs.register("drop_experience", DROP_EXPERIENCE);
        BlockCodecs.register("mushroom", MUSHROOM);
        BlockCodecs.register("flower", FLOWER);
        BlockCodecs.register("flower_pot", FLOWER_POT);
        BlockCodecs.register("wither_rose", WITHER_ROSE);
        BlockCodecs.register("button", BUTTON);
        BlockCodecs.register("pressure_plate", PRESSURE_PLATE);
        BlockCodecs.register("weathering_copper_full", WEATHERING_COPPER_FULL);
        BlockCodecs.register("weathering_copper_slab", WEATHERING_COPPER_SLAB);
        BlockCodecs.register("weathering_copper_stair", WEATHERING_COPPER_STAIR);
        BlockCodecs.register("bed", BED);
        BlockCodecs.register("brushable", BRUSHABLE);
        BlockCodecs.register("wall_sign", WALL_SIGN);
        BlockCodecs.register("standing_sign", STANDING_SIGN);
        BlockCodecs.register("wall_hanging_sign", WALL_HANGING_SIGN);
        BlockCodecs.register("ceiling_hanging_sign", CEILING_HANGING_SIGN);
    }
}

