/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.data.DataModule;

public class KiwiShapelessRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;
    private boolean noContainers;

    public KiwiShapelessRecipeBuilder(RecipeCategory recipeCategory, ItemLike itemLike, int i) {
        this.category = recipeCategory;
        this.result = itemLike.m_5456_();
        this.count = i;
    }

    public static KiwiShapelessRecipeBuilder shapeless(RecipeCategory recipeCategory, ItemLike itemLike) {
        return new KiwiShapelessRecipeBuilder(recipeCategory, itemLike, 1);
    }

    public static KiwiShapelessRecipeBuilder shapeless(RecipeCategory recipeCategory, ItemLike itemLike, int i) {
        return new KiwiShapelessRecipeBuilder(recipeCategory, itemLike, i);
    }

    public KiwiShapelessRecipeBuilder requires(TagKey<Item> tagKey) {
        return this.requires(Ingredient.m_204132_(tagKey));
    }

    public KiwiShapelessRecipeBuilder requires(ItemLike itemLike) {
        return this.requires(itemLike, 1);
    }

    public KiwiShapelessRecipeBuilder requires(ItemLike itemLike, int i) {
        for (int j = 0; j < i; ++j) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
        }
        return this;
    }

    public KiwiShapelessRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public KiwiShapelessRecipeBuilder requires(Ingredient ingredient, int i) {
        for (int j = 0; j < i; ++j) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public KiwiShapelessRecipeBuilder unlockedBy(String string, CriterionTriggerInstance criterionTriggerInstance) {
        this.advancement.m_138386_(string, criterionTriggerInstance);
        return this;
    }

    public KiwiShapelessRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public KiwiShapelessRecipeBuilder noContainers() {
        this.noContainers = true;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.ensureValid(resourceLocation);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)resourceLocation)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)resourceLocation)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(resourceLocation, this.result, this.count, this.group == null ? "" : this.group, KiwiShapelessRecipeBuilder.m_245179_((RecipeCategory)this.category), this.ingredients, this.advancement, resourceLocation.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.noContainers));
    }

    private void ensureValid(ResourceLocation resourceLocation) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(resourceLocation));
        }
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean noContainers;

        public Result(ResourceLocation resourceLocation, Item item, int i, String string, CraftingBookCategory craftingBookCategory, List<Ingredient> list, Advancement.Builder builder, ResourceLocation resourceLocation2, boolean noContainers) {
            super(craftingBookCategory);
            this.id = resourceLocation;
            this.result = item;
            this.count = i;
            this.group = string;
            this.ingredients = list;
            this.advancement = builder;
            this.advancementId = resourceLocation2;
            this.noContainers = noContainers;
        }

        public void m_7917_(JsonObject jsonObject) {
            super.m_7917_(jsonObject);
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonArray jsonArray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonArray.add(ingredient.m_43942_());
            }
            jsonObject.add("ingredients", (JsonElement)jsonArray);
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject2.addProperty("count", (Number)this.count);
            }
            jsonObject.add("result", (JsonElement)jsonObject2);
            if (this.noContainers) {
                jsonObject.addProperty("no_containers", Boolean.valueOf(true));
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return DataModule.SHAPELESS.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

