/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget.container.tabbed;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.background.Background;
import org.thinkingstudio.obsidianui.background.EmptyBackground;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.widget.SpruceSeparatorWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.WithBackground;
import org.thinkingstudio.obsidianui.widget.container.AbstractSpruceParentWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceEntryListWidget;

public class SpruceTabbedWidget
extends AbstractSpruceParentWidget<SpruceWidget> {
    private final Component title;
    private final SideTabList list;
    private final Position anchor;
    private boolean isLeft = false;

    public SpruceTabbedWidget(Position position, int width, int height, @Nullable Component title) {
        this(position, width, height, title, Math.max(100, width / 8), title != null ? 20 : 0);
    }

    public SpruceTabbedWidget(Position position, int width, int height, @Nullable Component title, int sideWidth, int sideTopOffset) {
        super(position, SpruceWidget.class);
        this.width = width;
        this.height = height;
        this.title = title;
        this.list = new SideTabList(Position.of(position, 0, sideTopOffset), sideWidth, height - sideTopOffset);
        this.anchor = Position.of(this, this.list.getWidth(), 0);
    }

    public SideTabList getList() {
        return this.list;
    }

    public void addTabEntry(Component title, @Nullable Component description, ContainerFactory factory) {
        this.addTabEntry(title, description, factory.build(this.getWidth() - this.list.getWidth(), this.getHeight()));
    }

    public void addTabEntry(Component title, @Nullable Component description, AbstractSpruceWidget container) {
        TabEntry entry = this.list.addTabEntry(title, description, container);
        entry.container.getPosition().setAnchor(this.anchor);
    }

    public void addSeparatorEntry(Component title) {
        this.list.addSeparatorEntry(title);
    }

    public boolean removeTabEntry(Component title) {
        return this.list.removeTabEntry(title);
    }

    public boolean removeSeparatorEntry(Component title) {
        return this.list.removeSeparatorEntry(title);
    }

    @Override
    public void setFocused(@Nullable SpruceWidget focused) {
        super.setFocused(focused);
    }

    @Override
    public List<SpruceWidget> children() {
        if (this.list.getCurrentTab() == null) {
            return List.of(this.list);
        }
        return List.of(this.list, this.list.getCurrentTab().container);
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        if (this.list.getCurrentTab() == null) {
            return super.onNavigation(direction, tab);
        }
        if (tab) {
            boolean result = this.list.getCurrentTab().container.onNavigation(direction, tab);
            this.setFocused(this.list.getCurrentTab().container.m_93696_() ? this.list.getCurrentTab().container : null);
            return result;
        }
        if (direction.isHorizontal()) {
            boolean result;
            if (direction == NavigationDirection.RIGHT) {
                if (this.list.getCurrentTab().container.onNavigation(direction, tab)) {
                    this.setFocused(this.list.getCurrentTab().container);
                }
            } else if (this.getFocused() != this.list && !(result = this.list.getCurrentTab().container.onNavigation(direction, tab))) {
                this.setFocused(this.list);
            }
            return true;
        }
        if (!this.m_93696_()) {
            this.m_93692_(true);
            this.setFocused(this.isLeft ? this.list : this.list.getCurrentTab().container);
        } else {
            boolean bl = this.isLeft = this.getFocused() == this.list;
        }
        if (this.getFocused() == null) {
            this.setFocused(this.isLeft ? this.list : this.list.getCurrentTab().container);
        }
        return this.getFocused().onNavigation(direction, tab);
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.title != null) {
            graphics.m_280653_(this.client.f_91062_, this.title, this.getX() + this.list.getWidth() / 2, this.getY() + 6, -1);
        }
        this.list.m_88315_(graphics, mouseX, mouseY, delta);
        if (this.list.getCurrentTab() != null) {
            this.list.getCurrentTab().container.m_88315_(graphics, mouseX, mouseY, delta);
        }
    }

    public static class SideTabList
    extends SpruceEntryListWidget<Entry> {
        private TabEntry currentTab = null;

        protected SideTabList(Position position, int width, int height) {
            super(position, width, height, 0, Entry.class);
            this.setRenderTransition(false);
        }

        public TabEntry getCurrentTab() {
            return this.currentTab;
        }

        @Override
        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (!focused) {
                this.setSelected(this.currentTab);
            }
        }

        public void setSelected(@Nullable TabEntry tab) {
            if (this.currentTab != null) {
                this.currentTab.selected = false;
            }
            if (tab != null) {
                tab.m_93692_(true);
            }
            this.setFocused(tab);
            this.currentTab = tab;
        }

        public TabEntry addTabEntry(Component title, @Nullable Component description, AbstractSpruceWidget container) {
            TabEntry entry = new TabEntry(this, title, description, container);
            this.addEntry(entry);
            if (this.getCurrentTab() == null) {
                this.setSelected(entry);
            }
            return entry;
        }

        public SeparatorEntry addSeparatorEntry(Component title) {
            SeparatorEntry entry = new SeparatorEntry(this, title);
            this.addEntry(entry);
            return entry;
        }

        @Override
        public boolean removeEntry(Entry entry) {
            if (this.getCurrentTab() == entry) {
                this.refocusTabOnRemoval(entry);
            }
            return super.removeEntry(entry);
        }

        public boolean removeTabEntry(Component title) {
            for (Entry entry : this) {
                if (!(entry instanceof TabEntry) || !entry.getTitle().equals((Object)title)) continue;
                return this.removeEntry(entry);
            }
            return false;
        }

        public boolean removeSeparatorEntry(Component title) {
            for (Entry entry : this) {
                if (!(entry instanceof SeparatorEntry) || !entry.getTitle().equals((Object)title)) continue;
                return this.removeEntry(entry);
            }
            return false;
        }

        protected void refocusTabOnRemoval(Entry focused) {
            Entry entry;
            int index;
            int currentIndex = this.children().indexOf(focused);
            for (index = currentIndex - 1; index >= 0; --index) {
                entry = (Entry)this.getEntry(index);
                if (!(entry instanceof TabEntry)) continue;
                TabEntry tabEntry = (TabEntry)entry;
                this.setSelected(tabEntry);
                return;
            }
            for (index = currentIndex + 1; index < this.children().size(); ++index) {
                entry = (Entry)this.getEntry(index);
                if (!(entry instanceof TabEntry)) continue;
                TabEntry tabEntry = (TabEntry)entry;
                this.setSelected(tabEntry);
                return;
            }
            this.setSelected(null);
        }

        @Override
        public boolean onNavigation(NavigationDirection direction, boolean tab) {
            if (this.requiresCursor()) {
                return false;
            }
            Entry old = (Entry)this.getFocused();
            boolean result = super.onNavigation(direction, tab);
            Entry focused = (Entry)this.getFocused();
            if (result && old != focused && focused instanceof TabEntry) {
                TabEntry tabEntry = (TabEntry)focused;
                this.setSelected(tabEntry);
            }
            return result;
        }
    }

    public static interface ContainerFactory {
        public AbstractSpruceWidget build(int var1, int var2);
    }

    public static class TabEntry
    extends Entry {
        private final List<FormattedCharSequence> title;
        private final List<FormattedCharSequence> description;
        private final AbstractSpruceWidget container;
        private boolean selected;

        protected TabEntry(SideTabList parent, Component title, @Nullable Component description, AbstractSpruceWidget container) {
            super(parent, title);
            this.title = this.client.f_91062_.m_92923_((FormattedText)title, this.parent.getWidth() - 18);
            this.description = description == null ? null : this.client.f_91062_.m_92923_((FormattedText)description, this.parent.getWidth() - 18);
            this.container = container;
            if (container instanceof SpruceEntryListWidget) {
                SpruceEntryListWidget listWidget = (SpruceEntryListWidget)container;
                listWidget.setAllowOutsideHorizontalNavigation(true);
            }
        }

        @Override
        public int getHeight() {
            int n;
            int n2 = this.title.size();
            Objects.requireNonNull(this.client.f_91062_);
            int n3 = 4 + (n2 * 9 + 4);
            if (this.description == null) {
                n = 0;
            } else {
                int n4 = this.description.size();
                Objects.requireNonNull(this.client.f_91062_);
                n = n4 * 9 + 4;
            }
            return n3 + n + 4;
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (focused) {
                this.selected = true;
            }
        }

        @Override
        protected boolean onMouseClick(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.playDownSound();
                this.parent.setSelected(this);
                return true;
            }
            return false;
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            int y = this.getY() + 4;
            for (FormattedCharSequence line : this.title) {
                graphics.m_280649_(this.client.f_91062_, line, this.getX() + 4, y, 0xFFFFFF, false);
                y += 9;
            }
            if (this.description != null) {
                y += 4;
                for (FormattedCharSequence line : this.description) {
                    graphics.m_280649_(this.client.f_91062_, line, this.getX() + 8, y, 0xFFFFFF, false);
                    y += 9;
                }
            }
        }

        @Override
        protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            super.renderBackground(graphics, mouseX, mouseY, delta);
            if (this.m_93696_() && this.parent.m_93696_()) {
                graphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight() - 4, 0x2FFFFFFF);
            } else if (this.selected || this.isMouseHovered()) {
                graphics.m_280509_(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight() - 4, 0x1AFFFFFF);
            }
        }

        public String toString() {
            return "SpruceTabbedWidget$TabEntry{title=" + String.valueOf(this.getTitle()) + ", description=" + String.valueOf(this.description) + ", position=" + String.valueOf(this.getPosition()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", container=" + String.valueOf(this.container) + ", selected=" + this.selected + ", background=" + String.valueOf(this.getBackground()) + "}";
        }
    }

    public static class SeparatorEntry
    extends Entry {
        private final SpruceSeparatorWidget separatorWidget;

        protected SeparatorEntry(SideTabList parent, Component title) {
            super(parent, title);
            this.separatorWidget = new SpruceSeparatorWidget(Position.of(this, 0, 2), this.getWidth(), title){

                @Override
                public int getWidth() {
                    return this.getWidth();
                }
            };
        }

        public SpruceSeparatorWidget getSeparatorWidget() {
            return this.separatorWidget;
        }

        @Override
        public int getHeight() {
            return this.separatorWidget.getHeight() + 6;
        }

        @Override
        public boolean onNavigation(NavigationDirection direction, boolean tab) {
            return this.separatorWidget.onNavigation(direction, tab);
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.separatorWidget.m_88315_(graphics, mouseX, mouseY, delta);
        }

        public String toString() {
            return "SpruceTabbedWidget$SeparatorEntry{title=" + String.valueOf(this.getTitle()) + ", position=" + String.valueOf(this.getPosition()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", background=" + String.valueOf(this.getBackground()) + "}";
        }
    }

    public static abstract class Entry
    extends SpruceEntryListWidget.Entry
    implements WithBackground {
        protected final SideTabList parent;
        private final Component title;
        private Background background = EmptyBackground.EMPTY_BACKGROUND;

        protected Entry(SideTabList parent, Component title) {
            this.parent = parent;
            this.title = title;
        }

        @Override
        public int getWidth() {
            return this.parent.getInnerWidth();
        }

        public Component getTitle() {
            return this.title;
        }

        @Override
        public Background getBackground() {
            return this.background;
        }

        @Override
        public void setBackground(Background background) {
            this.background = background;
        }

        @Override
        protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.getBackground().render(graphics, this, 0, mouseX, mouseY, delta);
        }
    }
}

