/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.redstone;

import com.hrznstudio.titanium.api.IEnumValues;
import com.hrznstudio.titanium.api.redstone.IRedstoneAction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class RedstoneManager<T extends IEnumValues<T> & IRedstoneAction>
implements INBTSerializable<CompoundTag> {
    private T action;
    private boolean lastRedstoneState;
    private boolean shouldWork;

    public RedstoneManager(T defaultValue, boolean lastRedstoneState) {
        this.action = defaultValue;
        this.lastRedstoneState = lastRedstoneState;
        this.shouldWork = true;
    }

    public T getAction() {
        return this.action;
    }

    public void setAction(T action) {
        this.action = action;
    }

    public boolean getLastRedstoneState() {
        return this.lastRedstoneState;
    }

    public void setLastRedstoneState(boolean lastRedstoneState) {
        if (!this.lastRedstoneState && lastRedstoneState) {
            this.shouldWork = true;
        }
        this.lastRedstoneState = lastRedstoneState;
    }

    public boolean shouldWork() {
        return !((IRedstoneAction)this.action).startsOnChange() || this.shouldWork;
    }

    public void finish() {
        this.shouldWork = false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag value = new CompoundTag();
        value.m_128359_("Name", ((IRedstoneAction)this.action).getName());
        value.m_128379_("LastState", this.lastRedstoneState);
        return value;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.action = (IEnumValues)this.action.getValue(nbt.m_128461_("Name"));
        this.lastRedstoneState = nbt.m_128471_("LastState");
    }
}

