/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;

public abstract class AbstractStationSlotLayoutProvider
extends GenericDataProvider {
    protected static final int SORT_WEAPON = 3;
    protected static final int SORT_HARVEST = 6;
    protected static final int SORT_RANGED = 8;
    protected static final int SORT_LARGE = 6;
    protected static final int SORT_ARMOR = 15;
    private final Map<ResourceLocation, StationSlotLayout.Builder> allLayouts = new HashMap<ResourceLocation, StationSlotLayout.Builder>();

    public AbstractStationSlotLayoutProvider(PackOutput packOutput) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/station_layouts", StationSlotLayoutLoader.GSON);
    }

    protected abstract void addLayouts();

    protected StationSlotLayout.Builder define(ResourceLocation id) {
        return this.allLayouts.computeIfAbsent(id, i -> StationSlotLayout.builder());
    }

    protected StationSlotLayout.Builder define(ItemLike item) {
        return this.define(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()));
    }

    protected StationSlotLayout.Builder defineModifiable(IModifiableDisplay item) {
        return this.define(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_())).translationKey(item.m_5456_().m_5524_()).icon(item.getRenderTool());
    }

    protected StationSlotLayout.Builder defineModifiable(Supplier<? extends IModifiableDisplay> item) {
        return this.defineModifiable(item.get());
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addLayouts();
        return AbstractStationSlotLayoutProvider.allOf(this.allLayouts.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((StationSlotLayout.Builder)entry.getValue()).build())));
    }
}

