/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.entity;

import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public enum EntityInteractFluidEffect implements FluidEffect<FluidEffectContext.Entity>
{
    INSTANCE;

    private final SingletonLoader<EntityInteractFluidEffect> loader = new SingletonLoader((Object)this);

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Entity context, IFluidHandler.FluidAction action) {
        Player player = context.getPlayer();
        if (player != null) {
            Level world = context.getLevel();
            Entity target = context.getTarget();
            if (!world.m_6857_().m_61937_(target.m_20183_())) {
                return 0.0f;
            }
            if (action.simulate()) {
                return 1.0f;
            }
            FeatureFlagSet enabled = world.m_246046_();
            for (InteractionHand hand : InteractionHand.values()) {
                if (!player.m_21120_(hand).m_246617_(enabled)) {
                    return 0.0f;
                }
                Vec3 hit = context.getLocation().m_82546_(target.m_20182_());
                InteractionResult result = ForgeHooks.onInteractEntityAt((Player)player, (Entity)target, (Vec3)hit, (InteractionHand)hand);
                if (result == null && !(result = target.m_7111_(player, hit, hand)).m_19077_()) {
                    result = player.m_36157_(context.getTarget(), hand);
                }
                if (result == InteractionResult.PASS) continue;
                if (result.m_19077_()) {
                    player.m_21011_(hand, true);
                    return 1.0f;
                }
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return Component.m_237115_((String)(FluidEffect.getTranslationKey(this.getLoader()) + ".entity"));
    }

    public SingletonLoader<EntityInteractFluidEffect> getLoader() {
        return this.loader;
    }
}

