/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.DynamicModifier;
import slimeknights.tconstruct.library.modifiers.util.StaticModifier;

public class ModifierDeferredRegister {
    private final String modId;
    private final Map<ModifierId, Supplier<? extends Modifier>> entries = new LinkedHashMap<ModifierId, Supplier<? extends Modifier>>();
    private final Set<ModifierId> expected = new LinkedHashSet<ModifierId>();
    private boolean seenRegisterEvent = false;

    public void register(IEventBus bus) {
        bus.addListener(EventPriority.NORMAL, false, ModifierManager.ModifierRegistrationEvent.class, this::handleEvent);
    }

    public <T extends Modifier> StaticModifier<T> register(String name, Supplier<? extends T> supplier) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after ModifierRegistrationEvent has been fired.");
        }
        ModifierId id = new ModifierId(this.modId, name);
        if (this.expected.contains((Object)id)) {
            throw new IllegalArgumentException("Already registered as an dynamic modifier " + id);
        }
        Supplier<? extends T> original = this.entries.put(id, supplier);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate static registration " + id);
        }
        return new StaticModifier(id);
    }

    public DynamicModifier registerDynamic(String name) {
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after ModifierRegistrationEvent has been fired.");
        }
        ModifierId id = new ModifierId(this.modId, name);
        if (this.entries.containsKey((Object)id)) {
            throw new IllegalArgumentException("Already registered as a static modifier " + id);
        }
        this.expected.add(id);
        return new DynamicModifier(id);
    }

    private void handleEvent(ModifierManager.ModifierRegistrationEvent event) {
        this.seenRegisterEvent = true;
        for (Map.Entry<ModifierId, Supplier<? extends Modifier>> entry : this.entries.entrySet()) {
            event.registerStatic(entry.getKey(), entry.getValue().get());
        }
        for (ModifierId id : this.expected) {
            event.registerExpected(id);
        }
    }

    private ModifierDeferredRegister(String modId) {
        this.modId = modId;
    }

    public static ModifierDeferredRegister create(String modId) {
        return new ModifierDeferredRegister(modId);
    }
}

