/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.molding;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MoldingRecipeBuilder
extends AbstractRecipeBuilder<MoldingRecipeBuilder> {
    private final ItemOutput output;
    private final TypeAwareRecipeSerializer<MoldingRecipe> serializer;
    private Ingredient material = Ingredient.f_43901_;
    private Ingredient pattern = Ingredient.f_43901_;
    private boolean patternConsumed = false;

    public static MoldingRecipeBuilder moldingTable(ItemLike item) {
        return MoldingRecipeBuilder.molding(ItemOutput.fromItem((ItemLike)item), (TypeAwareRecipeSerializer<MoldingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.moldingTableSerializer.get()));
    }

    public static MoldingRecipeBuilder moldingBasin(ItemLike item) {
        return MoldingRecipeBuilder.molding(ItemOutput.fromItem((ItemLike)item), (TypeAwareRecipeSerializer<MoldingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.moldingBasinSerializer.get()));
    }

    public MoldingRecipeBuilder setMaterial(Ingredient ingredient) {
        this.material = ingredient;
        return this;
    }

    public MoldingRecipeBuilder setMaterial(ItemLike item) {
        return this.setMaterial(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public MoldingRecipeBuilder setMaterial(TagKey<Item> tag) {
        return this.setMaterial(Ingredient.m_204132_(tag));
    }

    public MoldingRecipeBuilder setPattern(Ingredient ingredient, boolean consumed) {
        this.pattern = ingredient;
        this.patternConsumed = consumed;
        return this;
    }

    public MoldingRecipeBuilder setPattern(ItemLike item, boolean consumed) {
        return this.setPattern(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), consumed);
    }

    public MoldingRecipeBuilder setPattern(TagKey<Item> tag, boolean consumed) {
        return this.setPattern(Ingredient.m_204132_(tag), consumed);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)this.output.get().m_41720_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.material == Ingredient.f_43901_) {
            throw new IllegalStateException("Missing material for molding recipe");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "molding");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MoldingRecipe(this.serializer, id, this.material, this.pattern, this.patternConsumed, this.output), MoldingRecipe.LOADER, advancementId));
    }

    private MoldingRecipeBuilder(ItemOutput output, TypeAwareRecipeSerializer<MoldingRecipe> serializer) {
        this.output = output;
        this.serializer = serializer;
    }

    public static MoldingRecipeBuilder molding(ItemOutput output, TypeAwareRecipeSerializer<MoldingRecipe> serializer) {
        return new MoldingRecipeBuilder(output, serializer);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)MoldingRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            json.add("material", MoldingRecipeBuilder.this.material.m_43942_());
            if (MoldingRecipeBuilder.this.pattern != Ingredient.f_43901_) {
                json.add("pattern", MoldingRecipeBuilder.this.pattern.m_43942_());
                if (MoldingRecipeBuilder.this.patternConsumed) {
                    json.addProperty("pattern_consumed", Boolean.valueOf(true));
                }
            }
            json.add("result", MoldingRecipeBuilder.this.output.serialize(false));
        }

        public RecipeSerializer<?> m_6637_() {
            return MoldingRecipeBuilder.this.serializer;
        }
    }
}

