/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.worktable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;

public abstract class AbstractWorktableRecipe
implements IModifierWorktableRecipe {
    public static final Ingredient DEFAULT_TOOLS = Ingredient.m_204132_(TinkerTags.Items.MODIFIABLE);
    protected static final LoadableField<Ingredient, AbstractWorktableRecipe> TOOL_FIELD = IngredientLoadable.DISALLOW_EMPTY.defaultField("tools", (Object)DEFAULT_TOOLS, true, r -> r.toolRequirement);
    protected static final LoadableField<List<SizedIngredient>, AbstractWorktableRecipe> INPUTS_FIELD = SizedIngredient.LOADABLE.list(1).requiredField("inputs", r -> r.inputs);
    private final ResourceLocation id;
    protected final Ingredient toolRequirement;
    protected final List<SizedIngredient> inputs;
    @Nullable
    protected List<ItemStack> tools;

    public AbstractWorktableRecipe(ResourceLocation id, List<SizedIngredient> inputs) {
        this(id, Ingredient.m_204132_(TinkerTags.Items.MODIFIABLE), inputs);
    }

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        if (!this.toolRequirement.test(inv.getTinkerableStack())) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            return ModifierRecipeLookup.getRecipeModifierList();
        }
        return inv.getTinkerable().getUpgrades().getModifiers();
    }

    @Override
    public void updateInputs(LazyToolStack result, ITinkerableContainer.Mutable inv, ModifierEntry selected, boolean isServer) {
        ModifierRecipe.updateInputs(inv, this.inputs);
    }

    @Override
    public List<ItemStack> getInputTools() {
        if (this.tools == null) {
            this.tools = Arrays.stream(this.toolRequirement.m_43908_()).map(stack -> IModifiableDisplay.getDisplayStack(stack.m_41720_())).toList();
        }
        return this.tools;
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        if (slot < 0 || slot >= this.inputs.size()) {
            return Collections.emptyList();
        }
        return this.inputs.get(slot).getMatchingStacks();
    }

    @Override
    public int getInputCount() {
        return this.inputs.size();
    }

    public AbstractWorktableRecipe(ResourceLocation id, Ingredient toolRequirement, List<SizedIngredient> inputs) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.inputs = inputs;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

