/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialNBT
implements Iterable<MaterialVariant> {
    public static final MaterialNBT EMPTY = new MaterialNBT((List<MaterialVariant>)ImmutableList.of());
    private final List<MaterialVariant> list;

    public MaterialNBT(List<MaterialVariant> list) {
        this.list = ImmutableList.copyOf(list);
    }

    @VisibleForTesting
    public static MaterialNBT of(IMaterial ... materials) {
        return new MaterialNBT(Arrays.stream(materials).map(MaterialVariant::of).toList());
    }

    public static MaterialNBT of(MaterialVariant ... materials) {
        return new MaterialNBT(List.of(materials));
    }

    public static Builder builder() {
        return new Builder();
    }

    public MaterialVariant get(int index) {
        if (index >= this.list.size() || index < 0) {
            return MaterialVariant.UNKNOWN;
        }
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public MaterialNBT replaceMaterial(int index, MaterialVariant replacement) {
        int i;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Material index is out of bounds");
        }
        int size = this.list.size();
        ArrayList<MaterialVariant> list = new ArrayList<MaterialVariant>(Math.max(size, index + 1));
        for (i = 0; i < size; ++i) {
            if (i == index) {
                list.add(replacement);
                continue;
            }
            list.add(this.list.get(i));
        }
        if (index >= size) {
            for (i = size; i < index; ++i) {
                list.add(MaterialVariant.of(IMaterial.UNKNOWN, ""));
            }
            list.add(replacement);
        }
        return new MaterialNBT(list);
    }

    public MaterialNBT replaceMaterial(int index, MaterialVariantId replacement) {
        return this.replaceMaterial(index, MaterialVariant.of(replacement));
    }

    public static MaterialNBT readFromNBT(@Nullable Tag nbt) {
        if (nbt == null || nbt.m_7060_() != 9) {
            return EMPTY;
        }
        ListTag listNBT = (ListTag)nbt;
        if (listNBT.m_7264_() != 8 || listNBT.isEmpty()) {
            return EMPTY;
        }
        List<MaterialVariant> materials = listNBT.stream().map(tag -> Objects.requireNonNullElse(MaterialVariantId.tryParse(tag.m_7916_()), IMaterial.UNKNOWN_ID)).map(MaterialVariant::of).toList();
        return new MaterialNBT(materials);
    }

    public ListTag serializeToNBT() {
        return this.list.stream().map(lazy -> StringTag.m_129297_((String)lazy.getVariant().toString())).collect(Collectors.toCollection(ListTag::new));
    }

    @Override
    @Nonnull
    public Iterator<MaterialVariant> iterator() {
        return this.list.iterator();
    }

    @Override
    public void forEach(Consumer<? super MaterialVariant> action) {
        this.list.forEach(action);
    }

    @Override
    public Spliterator<MaterialVariant> spliterator() {
        return this.list.spliterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialNBT)) {
            return false;
        }
        MaterialNBT other = (MaterialNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MaterialVariant> this$list = this.getList();
        List<MaterialVariant> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MaterialVariant> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialNBT(list=" + this.getList() + ")";
    }

    public List<MaterialVariant> getList() {
        return this.list;
    }

    public static class Builder {
        private final ImmutableList.Builder<MaterialVariant> builder = ImmutableList.builder();

        public Builder add(MaterialVariant variant) {
            this.builder.add((Object)variant);
            return this;
        }

        public Builder add(MaterialVariantId variantId) {
            return this.add(MaterialVariant.of(variantId));
        }

        public Builder add(IMaterial material) {
            return this.add(MaterialVariant.of(material));
        }

        public Builder addAll(List<MaterialVariant> existing) {
            this.builder.addAll(existing);
            return this;
        }

        public Builder addAll(MaterialNBT existing) {
            return this.addAll(existing.list);
        }

        public MaterialNBT build() {
            ImmutableList materials = this.builder.build();
            if (materials.isEmpty()) {
                return EMPTY;
            }
            return new MaterialNBT((List<MaterialVariant>)materials);
        }
    }
}

