/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TrimModifier
extends NoLevelsModifier
implements ModifierRemovalHook {
    private static final String FORMAT_KEY = TConstruct.makeTranslationKey("modifier", "trim.formatted");
    public static final ResourceLocation TRIM_PATTERN = TConstruct.getResource("trim_pattern");
    public static final ResourceLocation TRIM_MATERIAL = TConstruct.getResource("trim_material");
    private final Map<String, Component> formattedCache = new HashMap<String, Component>();

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        ModDataNBT modDataNBT = tool.getPersistentData();
        String trimMaterial = modDataNBT.getString(TRIM_MATERIAL);
        String trimPattern = modDataNBT.getString(TRIM_PATTERN);
        Component original = this.getDisplayName();
        if (trimMaterial.isEmpty() || trimPattern.isEmpty()) {
            return original;
        }
        String key = trimMaterial + "#" + trimPattern;
        Component formatted = this.formattedCache.get(key);
        if (formatted == null) {
            if (access == null) {
                return original;
            }
            formatted = original;
            TrimMaterial material = (TrimMaterial)access.m_175515_(Registries.f_266076_).m_7745_(ResourceLocation.m_135820_((String)trimMaterial));
            TrimPattern pattern = (TrimPattern)access.m_175515_(Registries.f_266063_).m_7745_(ResourceLocation.m_135820_((String)trimPattern));
            if (material != null && pattern != null) {
                formatted = Component.m_237110_((String)FORMAT_KEY, (Object[])new Object[]{pattern.f_265850_(), material.f_266021_()}).m_130948_(material.f_266021_().m_7383_());
            }
            this.formattedCache.put(trimMaterial, formatted);
        }
        return formatted;
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.REMOVE);
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(TRIM_PATTERN);
        tool.getPersistentData().remove(TRIM_MATERIAL);
        return null;
    }
}

