/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RakedGravelBlock
extends GravelBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final EnumProperty<ModBlockProperties.RakeDirection> RAKE_DIRECTION = ModBlockProperties.RAKE_DIRECTION;

    public RakedGravelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_SOUTH)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RAKE_DIRECTION});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = super.m_49966_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        if (!blockstate.m_60710_((LevelReader)world, pos)) {
            return Block.m_49897_((BlockState)blockstate, (BlockState)Blocks.f_49994_.m_49966_(), (LevelAccessor)world, (BlockPos)pos);
        }
        Direction front = context.m_8125_();
        return RakedGravelBlock.getConnectedState(blockstate, (LevelAccessor)world, pos, front);
    }

    private static boolean canConnect(BlockState state, Direction dir) {
        if (state.m_60734_() == ModRegistry.RAKED_GRAVEL.get()) {
            return ((ModBlockProperties.RakeDirection)((Object)state.m_61143_(RAKE_DIRECTION))).getDirections().contains(dir.m_122424_());
        }
        return false;
    }

    public static BlockState getConnectedState(BlockState blockstate, LevelAccessor world, BlockPos pos, Direction front) {
        ArrayList<Direction> directionList = new ArrayList<Direction>();
        Direction back = front.m_122424_();
        if (RakedGravelBlock.canConnect(world.m_8055_(pos.m_121945_(back)), back)) {
            directionList.add(back);
        } else {
            directionList.add(front);
        }
        Direction side = front.m_122427_();
        for (int i = 0; i < 2; ++i) {
            BlockState state = world.m_8055_(pos.m_121945_(side));
            if (RakedGravelBlock.canConnect(state, side)) {
                directionList.add(side);
                break;
            }
            side = side.m_122424_();
        }
        return (BlockState)blockstate.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.fromDirections(directionList)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        ModBlockProperties.RakeDirection shape = (ModBlockProperties.RakeDirection)((Object)state.m_61143_(RAKE_DIRECTION));
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> {
                switch (shape) {
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                }
                yield state;
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.EAST_WEST));
                    }
                    case EAST_WEST: 
                }
                yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_SOUTH));
            }
            case Rotation.CLOCKWISE_90 -> {
                switch (shape) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_SOUTH: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.EAST_WEST));
                    }
                    case EAST_WEST: 
                }
                yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_SOUTH));
            }
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        ModBlockProperties.RakeDirection shape = (ModBlockProperties.RakeDirection)((Object)state.m_61143_(RAKE_DIRECTION));
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> {
                switch (shape) {
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case NORTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                }
                yield super.m_6943_(state, mirror);
            }
            case Mirror.FRONT_BACK -> {
                switch (shape) {
                    default: {
                        yield super.m_6943_(state, mirror);
                    }
                    case SOUTH_EAST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_WEST));
                    }
                    case SOUTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.SOUTH_EAST));
                    }
                    case NORTH_WEST: {
                        yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_EAST));
                    }
                    case NORTH_EAST: 
                }
                yield (BlockState)state.m_61124_(RAKE_DIRECTION, (Comparable)((Object)ModBlockProperties.RakeDirection.NORTH_WEST));
            }
            default -> super.m_6943_(state, mirror);
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState fromState, LevelAccessor world, BlockPos pos, BlockPos fromPos) {
        if (direction == Direction.UP && !state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, fromState, world, pos, fromPos);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            RakedGravelBlock.turnToGravel(state, (Level)world, pos);
        }
        super.m_213897_(state, world, pos, random);
    }

    public static void turnToGravel(BlockState state, Level world, BlockPos pos) {
        world.m_46597_(pos, RakedGravelBlock.m_49897_((BlockState)state, (BlockState)Blocks.f_49994_.m_49966_(), (LevelAccessor)world, (BlockPos)pos));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos.m_7494_());
        return !blockstate.m_280296_() || blockstate.m_60734_() instanceof FenceGateBlock;
    }
}

