/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.fire_behaviors;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.IEntityInterceptFakeLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GenericProjectileBehavior
implements IBallisticBehavior {
    private static final GameProfile FAKE_PLAYER = new GameProfile(UUID.fromString("11242C44-14d5-1f22-3d27-13D2C45CA355"), "[CANNON_TESTER]");

    @Override
    public IBallisticBehavior.Data calculateData(ItemStack projectile, Level level) {
        if (projectile.m_41619_()) {
            return IBallisticBehavior.LINE;
        }
        Entity proj = this.createEntity(projectile, (IEntityInterceptFakeLevel)IEntityInterceptFakeLevel.get(level), new Vec3(1.0, 0.0, 0.0));
        if (proj != null) {
            double speed = proj.m_20184_().m_82553_();
            if (speed == 0.0 && proj instanceof AbstractArrow) {
                speed = 2.0;
            }
            proj.m_20334_(1.0, 0.0, 0.0);
            proj.m_8119_();
            Vec3 newMovement = proj.m_20184_();
            float drag = (float)newMovement.f_82479_;
            float gravity = (float)(-newMovement.f_82480_);
            return new IBallisticBehavior.Data(drag, gravity, (float)speed);
        }
        return IBallisticBehavior.LINE;
    }

    @Override
    public boolean fireInner(ItemStack stack, ServerLevel level, Vec3 firePos, Vec3 facing, float scalePower, int inaccuracy, @Nullable Player owner) {
        Entity entity = this.createEntity(stack, (IEntityInterceptFakeLevel)IEntityInterceptFakeLevel.get((Level)level), facing);
        if (entity != null && (entity = MiscUtils.cloneEntity(entity, level)) != null) {
            if (entity instanceof Projectile) {
                Projectile pr = (Projectile)entity;
                pr.f_150163_ = null;
                pr.f_37244_ = null;
                pr.m_5602_((Entity)owner);
                pr.m_6686_(facing.f_82479_, facing.f_82480_, facing.f_82481_, scalePower, (float)inaccuracy);
            } else {
                entity.m_20256_(facing.m_82490_((double)scalePower));
            }
            entity.m_6034_(firePos.f_82479_, firePos.f_82480_, firePos.f_82481_);
            level.m_7967_(entity);
            return true;
        }
        return false;
    }

    @Nullable
    @VisibleForTesting
    public Entity createEntity(ItemStack projectile, IEntityInterceptFakeLevel testLevel, Vec3 facing) {
        Level fakeLevel = testLevel.cast();
        Player fakePlayer = FakePlayerManager.get((GameProfile)FAKE_PLAYER, (Level)fakeLevel);
        fakePlayer.m_146926_((float)MthUtils.getPitch((Vec3)facing));
        fakePlayer.m_146922_((float)MthUtils.getYaw((Vec3)facing));
        testLevel.setup();
        Item item = projectile.m_41720_();
        if (item instanceof ArrowItem) {
            ArrowItem ai = (ArrowItem)item;
            return ai.m_6394_(fakeLevel, projectile, (LivingEntity)fakePlayer);
        }
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, projectile.m_41777_());
        InteractionResultHolder<ItemStack> eventResult = SuppPlatformStuff.fireItemRightClickEvent(fakePlayer, InteractionHand.MAIN_HAND);
        if (!eventResult.m_19089_().m_19077_()) {
            projectile.m_41682_(fakeLevel, fakePlayer, InteractionHand.MAIN_HAND);
        }
        return testLevel.getIntercepted();
    }
}

