/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.render.FluidCuboid;
import slimeknights.mantle.data.datamap.BlockStateDataMapLoader;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record FaucetFluid(List<FluidCuboid> side, List<FluidCuboid> center, boolean isContinued) {
    public static final FaucetFluid EMPTY = new FaucetFluid(List.of(), List.of(), false);
    public static final RecordLoadable<FaucetFluid> LOADABLE = RecordLoadable.create(FluidCuboid.LIST_LOADABLE.requiredField("side", FaucetFluid::side), FluidCuboid.LIST_LOADABLE.requiredField("center", FaucetFluid::center), BooleanLoadable.INSTANCE.defaultField("continue", false, FaucetFluid::isContinued), FaucetFluid::new);
    public static final Loader REGISTRY = new Loader();
    private static boolean initialized = false;

    public static void initialize(RegisterClientReloadListenersEvent event) {
        if (initialized) {
            return;
        }
        initialized = true;
        event.registerReloadListener((PreparableReloadListener)REGISTRY);
    }

    public List<FluidCuboid> getFluids(Direction dir) {
        if (dir.m_122434_() == Direction.Axis.Y) {
            return this.center;
        }
        return this.side;
    }

    public static FaucetFluid fromJson(JsonObject json, FaucetFluid def) {
        List<FluidCuboid> side = FaucetFluid.parseFluids(json, "side", def.side);
        List<FluidCuboid> center = FaucetFluid.parseFluids(json, "center", def.center);
        boolean cont = GsonHelper.m_13855_((JsonObject)json, (String)"continue", (boolean)false);
        return new FaucetFluid(side, center, cont);
    }

    private static List<FluidCuboid> parseFluids(JsonObject json, String tag, List<FluidCuboid> def) {
        JsonElement element;
        if (json.has(tag)) {
            element = json.get(tag);
        } else if (json.has("bottom") && json.get("bottom").isJsonPrimitive()) {
            element = json.get("bottom");
        } else {
            return def;
        }
        if (element.isJsonPrimitive()) {
            int value = element.getAsInt();
            return def.stream().map(cuboid -> {
                Vector3f from = new Vector3f((Vector3fc)cuboid.getFrom());
                from.y = value;
                return new FluidCuboid(from, cuboid.getTo(), cuboid.getFaces());
            }).collect(Collectors.toList());
        }
        return FluidCuboid.LIST_LOADABLE.getIfPresent(json, tag);
    }

    public static class Loader
    extends BlockStateDataMapLoader<FaucetFluid> {
        private static final ResourceLocation DEFAULT_NAME = Mantle.getResource("_default");
        private FaucetFluid defaultInstance = EMPTY;
        private final DefaultingFaucetFluidLoader dataLoader = new DefaultingFaucetFluidLoader();

        public Loader() {
            super("Faucet Fluids", "mantle/model/faucet_fluid", LOADABLE);
        }

        @Override
        protected RecordLoadable<FaucetFluid> prepareLoader(Map<ResourceLocation, JsonElement> jsons) {
            JsonElement json = jsons.get(DEFAULT_NAME);
            this.defaultInstance = EMPTY;
            if (json == null) {
                Mantle.logger.warn("Found no default fluid model, this is likely a problem with the resource pack");
            } else {
                try {
                    this.defaultInstance = (FaucetFluid)LOADABLE.convert(json, DEFAULT_NAME.toString());
                }
                catch (Exception exception) {
                    Mantle.logger.error("Failed to load default faucet fluid model {}", (Object)DEFAULT_NAME, (Object)exception);
                }
            }
            return this.dataLoader;
        }

        @Override
        @Nonnull
        public FaucetFluid get(BlockState state) {
            return this.get(state, this.defaultInstance);
        }

        public FaucetFluid getDefaultInstance() {
            return this.defaultInstance;
        }

        private class DefaultingFaucetFluidLoader
        implements RecordLoadable<FaucetFluid> {
            private DefaultingFaucetFluidLoader() {
            }

            @Override
            public FaucetFluid deserialize(JsonObject json, TypedMap context) {
                return FaucetFluid.fromJson(json, Loader.this.defaultInstance);
            }

            @Override
            public void serialize(FaucetFluid object, JsonObject json) {
                LOADABLE.serialize(object, json);
            }

            @Override
            public FaucetFluid decode(FriendlyByteBuf buffer, TypedMap context) {
                return (FaucetFluid)LOADABLE.decode(buffer, context);
            }

            @Override
            public void encode(FriendlyByteBuf buffer, FaucetFluid value) {
                LOADABLE.encode(buffer, value);
            }
        }
    }
}

