/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.GeneratePackHelper;

public class HarvestTiersCommand {
    protected static final ResourceLocation HARVEST_TIERS = new ResourceLocation("forge", "item_tier_ordering.json");
    private static final String HARVEST_TIER_PATH = HARVEST_TIERS.m_135827_() + "/" + HARVEST_TIERS.m_135815_();
    private static final Component SUCCESS_LOG = Component.m_237115_((String)"command.mantle.harvest_tiers.success_log");
    private static final Component EMPTY = Component.m_237115_((String)"command.mantle.tag.empty");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).then(Commands.m_82127_((String)"save").executes(source -> HarvestTiersCommand.run((CommandContext<CommandSourceStack>)source, true)))).then(Commands.m_82127_((String)"log").executes(source -> HarvestTiersCommand.run((CommandContext<CommandSourceStack>)source, false)))).then(Commands.m_82127_((String)"list").executes(HarvestTiersCommand::list));
    }

    private static Object getTagComponent(TagKey<Block> tag) {
        ResourceLocation id = tag.f_203868_();
        return Component.m_237113_((String)id.toString()).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/mantle dump_tag " + Registries.f_256747_.m_135782_() + " " + id + " save")));
    }

    private static int list(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List sortedTiers = TierSortingRegistry.getSortedTiers();
        MutableComponent output = Component.m_237115_((String)"command.mantle.harvest_tiers.success_list");
        if (sortedTiers.isEmpty()) {
            output.m_130946_("\n* ").m_7220_(EMPTY);
        } else {
            for (Tier tier : sortedTiers) {
                output.m_130946_("\n* ");
                TagKey tag = tier.getTag();
                ResourceLocation id = TierSortingRegistry.getName((Tier)tier);
                if (tag != null) {
                    output.m_7220_((Component)Component.m_237110_((String)"command.mantle.harvest_tiers.tag", (Object[])new Object[]{id, HarvestTiersCommand.getTagComponent((TagKey<Block>)tag)}));
                    continue;
                }
                output.m_7220_((Component)Component.m_237110_((String)"command.mantle.harvest_tiers.no_tag", (Object[])new Object[]{id}));
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> output, true);
        return sortedTiers.size();
    }

    private static int run(CommandContext<CommandSourceStack> context, boolean saveFile) throws CommandSyntaxException {
        List sortedTiers = TierSortingRegistry.getSortedTiers();
        JsonArray entries = new JsonArray();
        for (Tier location : sortedTiers) {
            entries.add(Objects.requireNonNull(TierSortingRegistry.getName((Tier)location)).toString());
        }
        JsonObject json = new JsonObject();
        json.add("order", (JsonElement)entries);
        if (saveFile) {
            File output = new File(DumpAllTagsCommand.getOutputFile(context), HARVEST_TIER_PATH);
            Path path = output.toPath();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(DumpTagCommand.GSON.toJson((JsonElement)json));
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save harvests tiers to {}", (Object)path, (Object)ex);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.mantle.harvest_tiers.success_save", (Object[])new Object[]{GeneratePackHelper.getOutputComponent(output)}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SUCCESS_LOG, true);
            Mantle.logger.info("Dump of harvests tiers:\n{}", (Object)DumpTagCommand.GSON.toJson((JsonElement)json));
        }
        return sortedTiers.size();
    }
}

