/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.client;

import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.GenericDataProvider;

public abstract class GenericTextureGenerator
extends GenericDataProvider {
    @Nullable
    protected final ExistingFileHelper existingFileHelper;
    @Nullable
    private final ExistingFileHelper.ResourceType resourceType;

    public GenericTextureGenerator(PackOutput packOutput, @Nullable ExistingFileHelper existingFileHelper, String folder) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, folder);
        this.existingFileHelper = existingFileHelper;
        this.resourceType = existingFileHelper != null ? new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", folder) : null;
    }

    protected CompletableFuture<?> saveImage(CachedOutput cache, ResourceLocation location, NativeImage image) {
        if (this.existingFileHelper != null && this.resourceType != null) {
            this.existingFileHelper.trackGenerated(location, (ExistingFileHelper.IResourceType)this.resourceType);
        }
        return GenericTextureGenerator.saveImage(cache, this.pathProvider, location, image);
    }

    protected CompletableFuture<?> saveMetadata(CachedOutput cache, ResourceLocation location, JsonObject metadata) {
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)metadata, (Path)this.pathProvider.m_245527_(location, "png.mcmeta"));
    }

    public static NativeImage read(ExistingFileHelper existingFileHelper, String folder, ResourceLocation path) throws IOException {
        NativeImage nativeImage;
        block8: {
            Resource resource = existingFileHelper.getResource(path, PackType.CLIENT_RESOURCES, ".png", folder);
            InputStream stream = resource.m_215507_();
            try {
                nativeImage = NativeImage.m_85058_((InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchElementException e) {
                    Mantle.logger.error("Failed to read image at {}", (Object)path, (Object)e);
                    throw e;
                }
            }
            stream.close();
        }
        return nativeImage;
    }

    public static CompletableFuture<?> saveImage(CachedOutput cache, PackOutput.PathProvider pathProvider, ResourceLocation location, NativeImage image) {
        return CompletableFuture.runAsync(() -> {
            try {
                Path path = pathProvider.m_245527_(location, "png");
                byte[] bytes = image.m_85121_();
                cache.m_213871_(path, bytes, Hashing.sha1().hashBytes(bytes));
            }
            catch (IOException e) {
                Mantle.logger.error("Couldn't write image for {}", (Object)location, (Object)e);
                throw new CompletionException(e);
            }
        }, Util.m_183991_());
    }
}

