/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public abstract class LegacyLoadable<T>
implements RecordLoadable<T> {
    protected final RecordLoadable<T> base;

    @Override
    public JsonElement serialize(T object) {
        return this.base.serialize(object);
    }

    @Override
    public void serialize(T object, JsonObject json) {
        this.base.serialize(object, json);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T value) {
        this.base.encode(buffer, value);
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        return (T)this.base.decode(buffer, context);
    }

    @Override
    public <P> LoadableField<T, P> nullableField(String key, Function<P, T> getter) {
        return this.base.nullableField(key, getter);
    }

    @Override
    public <P> LoadableField<T, P> defaultField(String key, T defaultValue, boolean serializeDefault, Function<P, T> getter) {
        return this.base.defaultField(key, defaultValue, serializeDefault, getter);
    }

    public static String whileParsing(TypedMap context) {
        String debug = context.get(ContextKey.DEBUG);
        return debug != null ? " while parsing " + debug : "";
    }

    public static <T> RecordLoadable<T> message(RecordLoadable<T> loader, String message) {
        return new DeprecatedLoader<T>(loader, message);
    }

    public LegacyLoadable(RecordLoadable<T> base) {
        this.base = base;
    }

    private static class DeprecatedLoader<T>
    extends LegacyLoadable<T> {
        private final String message;

        public DeprecatedLoader(RecordLoadable<T> base, String message) {
            super(base);
            this.message = message;
        }

        @Override
        public T deserialize(JsonObject json, TypedMap context) {
            Mantle.logger.warn("{}", (Object)this.message);
            return this.base.deserialize(json, context);
        }
    }
}

