/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootContext;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.loot.condition.ILootModifierCondition;

public class ContainsItemModifierLootCondition
implements ILootModifierCondition {
    public static final ResourceLocation ID = Mantle.getResource("contains_item");
    private final Ingredient ingredient;
    private final int amountNeeded;

    public ContainsItemModifierLootCondition(Ingredient ingredient) {
        this(ingredient, 1);
    }

    @Override
    public boolean test(List<ItemStack> generatedLoot, LootContext context) {
        int matched = 0;
        for (ItemStack stack : generatedLoot) {
            if (!this.ingredient.test(stack) || (matched += stack.m_41613_()) < this.amountNeeded) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("ingredient", this.ingredient.m_43942_());
        if (this.amountNeeded != 1) {
            json.addProperty("needed", (Number)this.amountNeeded);
        }
        return json;
    }

    public static ContainsItemModifierLootCondition deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"condition");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
        int needed = GsonHelper.m_13824_((JsonObject)json, (String)"needed", (int)1);
        return new ContainsItemModifierLootCondition(ingredient, needed);
    }

    public ContainsItemModifierLootCondition(Ingredient ingredient, int amountNeeded) {
        this.ingredient = ingredient;
        this.amountNeeded = amountNeeded;
    }
}

