/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.mantle.registration.object.EnumObject;

public abstract class DeferredRegisterWrapper<T> {
    protected final SynchronizedDeferredRegister<T> register;
    protected final String modID;

    protected DeferredRegisterWrapper(ResourceKey<Registry<T>> reg, String modID) {
        this(DeferredRegister.create(reg, (String)modID), modID);
    }

    protected DeferredRegisterWrapper(DeferredRegister<T> register, String modID) {
        this.register = SynchronizedDeferredRegister.create(register);
        this.modID = modID;
    }

    public void register(IEventBus bus) {
        this.register.register(bus);
    }

    protected ResourceLocation resource(String name) {
        return new ResourceLocation(this.modID, name);
    }

    protected String resourceName(String name) {
        return this.modID + ":" + name;
    }

    protected static String getName(Enum<?> value) {
        String string;
        if (value instanceof StringRepresentable) {
            StringRepresentable representable = (StringRepresentable)value;
            string = representable.m_7912_();
        } else {
            string = value.name().toLowerCase(Locale.ROOT);
        }
        return string;
    }

    protected static <E extends Enum<E>, V extends T, T> EnumObject<E, V> registerEnum(E[] values, String name, BiFunction<String, E, Supplier<? extends V>> register) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have at least one value");
        }
        EnumObject.Builder<E, Supplier<? extends V>> builder = new EnumObject.Builder<E, Supplier<? extends V>>(((Enum)values[0]).getDeclaringClass());
        for (E value : values) {
            builder.put(value, register.apply(DeferredRegisterWrapper.getName(value) + "_" + name, value));
        }
        return builder.build();
    }

    protected static <E extends Enum<E>, V extends T, T> EnumObject<E, V> registerEnum(String name, E[] values, BiFunction<String, E, Supplier<? extends V>> register) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Must have at least one value");
        }
        EnumObject.Builder<E, Supplier<? extends V>> builder = new EnumObject.Builder<E, Supplier<? extends V>>(((Enum)values[0]).getDeclaringClass());
        for (E value : values) {
            builder.put(value, register.apply(name + "_" + DeferredRegisterWrapper.getName(value), value));
        }
        return builder.build();
    }
}

