/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.ProcessPopup;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ButtonGroup;
import com.tom.cpl.gui.util.ElementGroup;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.HorizontalLayout;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.gui.util.TabbedPanelManager;
import com.tom.cpl.math.Box;
import com.tom.cpl.text.KeybindText;
import com.tom.cpl.util.EmbeddedLocalizations;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpl.util.Pair;
import com.tom.cpm.externals.org.apache.maven.artifact.versioning.ComparableVersion;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.Generators;
import com.tom.cpm.shared.editor.TestIngameManager;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.elements.RootGroups;
import com.tom.cpm.shared.editor.gui.AnimPanel;
import com.tom.cpm.shared.editor.gui.AnimTestPanel;
import com.tom.cpm.shared.editor.gui.DrawToolsPanel;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.gui.PartSearchPopup;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.gui.TextureEditorPanel;
import com.tom.cpm.shared.editor.gui.TreePanel;
import com.tom.cpm.shared.editor.gui.ViewportPaintPanel;
import com.tom.cpm.shared.editor.gui.ViewportPanel;
import com.tom.cpm.shared.editor.gui.ViewportPanelAnim;
import com.tom.cpm.shared.editor.gui.popup.ChangelogPopup;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;
import com.tom.cpm.shared.editor.gui.popup.DescPopup;
import com.tom.cpm.shared.editor.gui.popup.ErrorLogPopup;
import com.tom.cpm.shared.editor.gui.popup.ExportPopup;
import com.tom.cpm.shared.editor.gui.popup.FirstStartPopup;
import com.tom.cpm.shared.editor.gui.popup.ModelsPopup;
import com.tom.cpm.shared.editor.gui.popup.SettingsPopup;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup;
import com.tom.cpm.shared.editor.tags.TagEditorPopup;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateSettings;
import com.tom.cpm.shared.gui.Keybinds;
import com.tom.cpm.shared.gui.KeybindsPopup;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.paste.PastePopup;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class EditorGui
extends Frame {
    public static boolean rescaleGui = true;
    public static boolean showExportWarn = true;
    private static List<File> recent = new ArrayList<File>();
    private static Editor toReopen;
    private TabbedPanelManager tabs;
    private HorizontalLayout topPanel;
    private Editor editor;
    private ViewType viewType;
    private static boolean smallGuiWarning;
    private static boolean notSupportedWarning;
    private static boolean showFirstStart;
    private static String showChangelog;
    private static boolean showNewVersionPopup;
    private Tooltip msgTooltip;
    private long tooltipTime;

    private static void addRecent(File file) {
        if (recent.contains(file)) {
            recent.remove(file);
        }
        while (recent.size() > 10) {
            recent.remove(0);
        }
        recent.add(file);
        ConfigEntry.ConfigEntryList ce = ModConfig.getCommonConfig().getEntryList("editorRecentProjects");
        ce.clear();
        recent.stream().filter(File::exists).map(File::getAbsolutePath).forEach(ce::add);
        ModConfig.getCommonConfig().save();
    }

    public EditorGui(IGui gui) {
        super(gui);
        rescaleGui = true;
        if (toReopen != null) {
            this.editor = toReopen;
            this.editor.setUI(gui);
            if (MinecraftClientAccess.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.INSTALLED) {
                toReopen = null;
                ModConfig.getCommonConfig().clearValue("reopenProject");
                ModConfig.getCommonConfig().save();
            }
        } else {
            this.editor = new Editor();
            this.editor.setUI(gui);
        }
        TestIngameManager.checkConfig();
        gui.setCloseListener(c -> {
            if (toReopen != null && this.editor.dirty) {
                this.openPopup(new ConfirmPopup(this, gui.i18nFormat("label.cpm.unsavedInGame", new Object[0]), (Runnable)c, null));
            } else {
                this.checkUnsaved(() -> {
                    this.editor.free();
                    c.run();
                });
            }
        });
    }

    private void checkUnsaved(Runnable r) {
        if (this.editor.dirty) {
            this.openPopup(new ConfirmPopup(this, this.gui.i18nFormat("label.cpm.unsaved", new Object[0]), r, null));
        } else {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initFrame(int width, int height) {
        String reopen;
        int scale = ModConfig.getCommonConfig().getInt("editorScale", -1);
        if (scale != -1 && rescaleGui && this.gui.getScale() != scale) {
            rescaleGui = false;
            try {
                this.gui.setScale(scale);
            }
            finally {
                rescaleGui = true;
            }
            return;
        }
        this.editor.reinit();
        this.viewType = ViewType.MODEL;
        this.tabs = new TabbedPanelManager(this.gui);
        this.tabs.setBounds(new Box(0, 20, width, height - 20));
        this.addElement(this.tabs);
        Panel topPanel = new Panel(this.gui);
        topPanel.setBounds(new Box(0, 0, width, 20));
        topPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        this.addElement(topPanel);
        this.topPanel = new HorizontalLayout(topPanel);
        this.initFileMenu();
        this.initEditMenu();
        this.initEffectMenu();
        this.initDisplayMenu();
        this.topPanel.addX(2);
        this.initModelPanel(width, height);
        this.initTexturePanel(width, height);
        this.initAnimPanel(width, height);
        Label title = new Label(this.gui, "");
        this.editor.setNameDisplay.add(title::setText);
        title.setBounds(new Box(5, 8, 0, 0));
        this.topPanel.add(title);
        this.editor.updateGui();
        if (smallGuiWarning && (height < 420 || width < 500)) {
            this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.warning", new Object[0]), this.gui.i18nFormat("label.cpm.gui_scale_too_large", new Object[0])));
        }
        smallGuiWarning = false;
        if (notSupportedWarning && !PlatformFeature.EDITOR_SUPPORTED.isSupported()) {
            this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.warning", new Object[0]), this.gui.i18nFormat("label.cpm.editor_not_supported", new Object[0])));
        }
        notSupportedWarning = false;
        if (showFirstStart) {
            this.openPopup(new FirstStartPopup(this.gui));
            showFirstStart = false;
        }
        if (showChangelog != null) {
            this.openPopup(new ChangelogPopup(this.gui, showChangelog));
            showChangelog = null;
        }
        if (showNewVersionPopup) {
            this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.changelog.newVersion.title", new Object[0]), this.gui.i18nFormat("label.cpm.changelog.newVersion.desc", new Object[0])));
            showNewVersionPopup = false;
        }
        if (toReopen == null && (reopen = ModConfig.getCommonConfig().getString("reopenProject", null)) != null) {
            ModConfig.getCommonConfig().clearValue("reopenProject");
            ModConfig.getCommonConfig().save();
            File f = new File(reopen);
            this.openPopup(new ConfirmPopup(this, this.gui.i18nFormat("label.cpm.reopenProject", f.getName()), () -> this.load(f), null));
        }
        this.editor.setInfoMsg.add(p -> {
            this.msgTooltip = new Tooltip(this, this.gui.wordWrap((String)p.getValue(), width));
            this.tooltipTime = System.currentTimeMillis() + (long)((Integer)p.getKey()).intValue();
        });
        MinecraftClientAccess.get().populatePlatformSettings("editor", this);
    }

    private Panel initQuickPanel(int x, int y, int w) {
        Panel quickActPanel = new Panel(this.gui);
        quickActPanel.setBounds(new Box(x, y, w, 0));
        FlowLayout layout = new FlowLayout(quickActPanel, 0, 1);
        this.editor.setQuickAction.add(q -> {
            quickActPanel.getElements().clear();
            if (q != null) {
                q.initButtons(this.gui, quickActPanel);
                layout.run();
                int h = quickActPanel.getBounds().h;
                quickActPanel.setBounds(new Box(x, y - h, w, h));
                quickActPanel.setVisible(true);
            } else {
                quickActPanel.setVisible(false);
            }
        });
        return quickActPanel;
    }

    private void initModelPanel(int width, int height) {
        Panel mainPanel = new Panel(this.gui);
        mainPanel.setBounds(new Box(0, 0, width, height - 20));
        ScrollPanel sp = new ScrollPanel(this.gui);
        sp.setDisplay(new PosPanel(this.gui, this));
        sp.setBounds(new Box(0, 0, 170, height - 20));
        sp.setScrollBarSide(true);
        mainPanel.addElement(sp);
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.model", new Object[0]), mainPanel, () -> {
            this.viewType = ViewType.MODEL;
        }));
        mainPanel.addElement(new TreePanel(this.gui, this, width, height - 20, true));
        ViewportPanel view = new ViewportPanel(this, this.editor);
        view.setBounds(new Box(170, 0, width - 320, height - 20));
        mainPanel.addElement(view);
        this.editor.displayViewport.add(view::setEnabled);
        mainPanel.addElement(this.initQuickPanel(Math.max(width - 350, 170), height - 20, Math.min(200, width - 320)));
    }

    private void initTexturePanel(int width, int height) {
        Panel textureEditor = new Panel(this.gui);
        textureEditor.setBounds(new Box(0, 0, width, height - 20));
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.texture", new Object[0]), textureEditor, () -> {
            this.viewType = ViewType.TEXTURE;
        }));
        ViewportPaintPanel viewT = new ViewportPaintPanel(this, this.editor);
        viewT.setBounds(new Box(0, 0, width - height / 2, height - 20));
        textureEditor.addElement(viewT);
        this.editor.cursorPos = viewT::getHoveredTexPos;
        this.editor.displayViewport.add(viewT::setEnabled);
        TextureEditorPanel tdp = new TextureEditorPanel(this.gui, this.editor, height / 2);
        tdp.setBounds(new Box(width - height / 2, 0, height / 2, height / 2));
        textureEditor.addElement(tdp);
        int treeW = Math.min(150, height / 2);
        TreePanel treePanel = new TreePanel(this.gui, this, treeW, height / 2 - 20, false);
        treePanel.setBounds(new Box(width - treeW, height / 2, treeW, height / 2));
        textureEditor.addElement(treePanel);
        textureEditor.addElement(new DrawToolsPanel(this, width - height / 2, height / 2, height / 2 - treeW, height / 2 - 19));
        Panel uvPanel = new Panel(this.gui);
        uvPanel.setBounds(new Box(0, height, 175, 0));
        uvPanel.setBackgroundColor(this.gui.getColors().panel_background);
        ElementGroup<ModeDisplayType, GuiElement> group = new ElementGroup<ModeDisplayType, GuiElement>(GuiElement::setVisible);
        this.editor.setModePanel.add(group);
        this.editor.setModePanel.add(mdt -> {
            uvPanel.setVisible(mdt != ModeDisplayType.NULL);
            if (mdt != ModeDisplayType.NULL) {
                int h = ((GuiElement)group.getFirst(mdt)).getBounds().h + 5;
                uvPanel.setBounds(new Box(0, height - 20 - h, 175, h));
            }
        });
        TabFocusHandler tabHandler = new TabFocusHandler(this.gui);
        Panel panel = new Panel(this.gui);
        panel.setBounds(new Box(0, 5, 170, 100));
        for (ModeDisplayType mdt2 : ModeDisplayType.VALUES) {
            if (mdt2 == ModeDisplayType.NULL) continue;
            Panel p = mdt2.factory.apply(this, this.editor, tabHandler);
            panel.addElement(p);
            group.addElement(mdt2, p);
        }
        uvPanel.addElement(panel);
        uvPanel.addElement(tabHandler);
        textureEditor.addElement(uvPanel);
        int w = height / 2 - treeW;
        int x = width - height / 2;
        if (w < 70) {
            x -= 70 - w;
        }
        w = Math.min(200, x - Math.max(x - 200, 175));
        textureEditor.addElement(this.initQuickPanel(Math.max(x - 200, 175), height - 20, w));
    }

    private void initAnimPanel(int width, int height) {
        Panel mainPanel = new Panel(this.gui);
        mainPanel.setBounds(new Box(0, 0, width, height - 20));
        Panel buttonsPanel = new Panel(this.gui);
        buttonsPanel.setBounds(new Box(0, 0, 170, 20));
        buttonsPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        HorizontalLayout buttons = new HorizontalLayout(buttonsPanel);
        TabbedPanelManager animPanelTabs = new TabbedPanelManager(this.gui);
        ScrollPanel spSetup = new ScrollPanel(this.gui);
        spSetup.setBounds(new Box(0, 0, 170, height - 40));
        spSetup.setDisplay(new AnimPanel(this.gui, this));
        spSetup.setScrollBarSide(true);
        ScrollPanel spTest = new ScrollPanel(this.gui);
        spTest.setBounds(new Box(0, 0, 170, height - 40));
        spTest.setDisplay(new AnimTestPanel(this.gui, this));
        spTest.setScrollBarSide(true);
        buttons.add(animPanelTabs.createTab(this.gui.i18nFormat("tab.cpm.animation.setup", new Object[0]), spSetup));
        buttons.add(animPanelTabs.createTab(this.gui.i18nFormat("tab.cpm.animation.test", new Object[0]), spTest));
        animPanelTabs.setBounds(new Box(0, 20, 170, height - 40));
        mainPanel.addElement(animPanelTabs);
        mainPanel.addElement(buttonsPanel);
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.animation", new Object[0]), mainPanel, () -> {
            this.viewType = ViewType.ANIMATION;
        }));
        mainPanel.addElement(new TreePanel(this.gui, this, width, height - 20, false){

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                EditorGui.this.editor.applyAnim = true;
                super.draw(event, partialTicks);
                EditorGui.this.editor.applyAnim = false;
            }
        });
        ViewportPanelAnim view = new ViewportPanelAnim(this, this.editor);
        view.setBounds(new Box(170, 0, width - 170 - 150, height - 20));
        mainPanel.addElement(view);
        this.editor.displayViewport.add(view::setEnabled);
        mainPanel.addElement(this.initQuickPanel(Math.max(width - 350, 170), height - 20, Math.min(200, width - 320)));
    }

    private void newModel(SkinType type) {
        this.checkUnsaved(() -> {
            this.editor.loadDefaultPlayerModel();
            this.editor.customSkinType = true;
            this.editor.skinType = type;
            this.editor.updateGui();
        });
    }

    private void initFileMenu() {
        PopupMenu pp = new PopupMenu(this.gui, this);
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.file", new Object[0]), () -> pp.display(0, 20)));
        PopupMenu newMenu = new PopupMenu(this.gui, this);
        PopupMenu newModelMenu = new PopupMenu(this.gui, this);
        newMenu.addMenuButton(this.gui.i18nFormat("button.cpm.new.model", new Object[0]), newModelMenu);
        for (SkinType type : SkinType.VANILLA_TYPES) {
            newModelMenu.addButton(this.gui.i18nFormat("label.cpm.skin_type." + type.getName(), new Object[0]), () -> this.newModel(type));
        }
        Button newTempl = newMenu.addButton(this.gui.i18nFormat("button.cpm.new.template", new Object[0]), () -> this.checkUnsaved(new ConfirmPopup(this, this.gui.i18nFormat("label.cpm.warning", new Object[0]), this.gui.i18nFormat("label.cpm.warnTemplate", new Object[0]), () -> {
            this.editor.loadDefaultPlayerModel();
            this.editor.templateSettings = new TemplateSettings(this.editor);
            Generators.setupTemplateModel(this.editor);
            ETextures skin = this.editor.textures.get((Object)TextureSheetType.SKIN);
            skin.setImage(new Image(64, 64));
            skin.setChangedLocally(false);
            skin.markDirty();
            this.editor.updateGui();
        }, null)));
        newTempl.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.new.template", new Object[0])));
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.file.new", new Object[0]), newMenu);
        pp.addButton(this.gui.i18nFormat("button.cpm.file.load", new Object[0]), () -> this.checkUnsaved(() -> {
            FileChooserPopup fc = new FileChooserPopup(this);
            fc.setTitle(EmbeddedLocalizations.loadProject);
            fc.setFileDescText(EmbeddedLocalizations.fileProject);
            fc.setFilter(new FileChooserPopup.FileFilter("cpmproject"));
            fc.setAccept(this::load);
            fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
            this.openPopup(fc);
        }));
        pp.addButton(this.gui.i18nFormat("button.cpm.file.save", new Object[0]), this::save);
        pp.addButton(this.gui.i18nFormat("button.cpm.file.saveAs", new Object[0]), this::saveAs);
        PopupMenu importMenu = new PopupMenu(this.gui, this);
        importMenu.addButton(this.gui.i18nFormat("button.cpm.file.import.project", new Object[0]), () -> {
            FileChooserPopup fc = new FileChooserPopup(this);
            fc.setTitle(EmbeddedLocalizations.importFile);
            fc.setFileDescText(EmbeddedLocalizations.fileProject);
            fc.setFilter(new FileChooserPopup.FileFilter("cpmproject"));
            fc.setAccept(f -> {});
            fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
            this.openPopup(fc);
        });
        pp.addButton(this.gui.i18nFormat("button.cpm.file.export", new Object[0]), () -> {
            this.openPopup(ExportPopup.createPopup(this));
            if (showExportWarn) {
                this.gui.displayMessagePopup(this.gui.i18nFormat("label.cpm.warning", new Object[0]), this.gui.i18nFormat("label.cpm.exportWarn", new Object[0]));
                showExportWarn = false;
            }
        }).setTooltip(new Tooltip((Frame)this, this.gui.i18nFormat("tooltip.cpm.export", new Object[0]), "Exporting"));
        pp.addButton(this.gui.i18nFormat("button.cpm.file.test", new Object[0]), () -> {
            if (TestIngameManager.openTestIngame(this, false)) {
                toReopen = this.editor;
            }
        });
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.openRecent", new Object[0]), () -> {
            PopupMenu menu = new PopupMenu(this.gui, this);
            for (int i = recent.size() - 1; i >= 0; --i) {
                File f = recent.get(i);
                if (!f.exists()) continue;
                menu.addButton(f.getName(), () -> this.checkUnsaved(() -> this.load(f))).setTooltip(new Tooltip(this, f.getAbsolutePath().replace('\\', '/')));
            }
            return menu;
        });
        pp.addButton(this.gui.i18nFormat("button.cpm.file.exit", new Object[0]), this.gui::closeGui);
        MinecraftClientAccess.get().populatePlatformSettings("filePopup", pp);
    }

    private void save() {
        if (this.editor.file != null) {
            this.saveProject(this.editor.file);
        } else {
            this.saveAs();
        }
    }

    private void saveAs() {
        FileChooserPopup fc = new FileChooserPopup(this);
        fc.setTitle(EmbeddedLocalizations.saveProject);
        fc.setFileDescText(EmbeddedLocalizations.fileProject);
        fc.setFilter(new FileChooserPopup.FileFilter("cpmproject"));
        fc.setSaveDialog(true);
        fc.setExtAdder(n -> n + ".cpmproject");
        fc.setAccept(this::saveProject);
        fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
        this.openPopup(fc);
    }

    private void initEditMenu() {
        PopupMenu pp = new PopupMenu(this.gui, this);
        int x = this.topPanel.getX();
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.edit", new Object[0]), () -> pp.display(x, 20)));
        Button undo = pp.addButton(this.gui.i18nFormat("button.cpm.edit.undo", new Object[0]), this.editor::undo);
        this.editor.setUndo.add(t -> {
            undo.setEnabled(t != null);
            undo.setText(t == null || t.isEmpty() ? this.gui.i18nFormat("button.cpm.edit.undo", new Object[0]) : this.gui.i18nFormat("button.cpm.edit.undoAction", t));
        });
        Button redo = pp.addButton(this.gui.i18nFormat("button.cpm.edit.redo", new Object[0]), this.editor::redo);
        this.editor.setRedo.add(t -> {
            redo.setEnabled(t != null);
            redo.setText(t == null || t.isEmpty() ? this.gui.i18nFormat("button.cpm.edit.redo", new Object[0]) : this.gui.i18nFormat("button.cpm.edit.redoAction", t));
        });
        PopupMenu tools = new PopupMenu(this.gui, this);
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.edit.tools", new Object[0]), tools);
        Generators.generators.forEach(g -> {
            Button btn = tools.addButton(this.gui.i18nFormat(g.name, new Object[0]), () -> g.func.accept(this));
            if (g.tooltip != null) {
                btn.setTooltip(new Tooltip(this, g.tooltip.toString(this.gui)));
            }
        });
        pp.addButton(this.gui.i18nFormat("button.cpm.edit.add_template", new Object[0]), new InputPopup(this, this.gui.i18nFormat("label.cpm.template_link_input", new Object[0]), this.gui.i18nFormat("label.cpm.template_link_input.desc", new Object[0]), link -> new ProcessPopup<EditorTemplate>(this, this.gui.i18nFormat("label.cpm.loading_template", new Object[0]), this.gui.i18nFormat("label.cpm.loading_template.desc", new Object[0]), () -> EditorTemplate.create(this.editor, link), t -> {
            this.editor.templates.add((EditorTemplate)t);
            this.editor.restitchTextures();
            this.editor.markDirty();
            this.editor.updateGui();
        }, e -> {
            if (e instanceof InterruptedException) {
                return;
            }
            Log.warn("Failed to download template", e);
            this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.template_load_error", e.getMessage())));
        }).start(), null));
        pp.addButton(this.gui.i18nFormat("label.cpm.desc", new Object[0]), () -> this.openPopup(new DescPopup(this, true, null)));
        PopupMenu parts = new PopupMenu(this.gui, this);
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.edit.parts", new Object[0]), parts);
        RootGroups.forEach(c -> parts.addButton(this.gui.i18nFormat("button.cpm.root_group." + c.name().toLowerCase(Locale.ROOT), new Object[0]), () -> this.editor.addRoot((RootGroups)((Object)c))));
        parts.addButton(this.gui.i18nFormat("button.cpm.root_group.itemHoldPos", new Object[0]), () -> Generators.addItemHoldPos(this.editor));
        parts.addButton(this.gui.i18nFormat("button.cpm.root_group.parrots", new Object[0]), () -> Generators.addParrots(this.editor));
        pp.addButton(this.gui.i18nFormat("button.cpm.tags", new Object[0]), () -> this.openPopup(new TagEditorPopup(this)));
        pp.add(new Label(this.gui, "=========").setBounds(new Box(5, 5, 0, 0)));
        pp.addButton(this.gui.i18nFormat("button.cpm.edit.settings", new Object[0]), () -> this.openPopup(new SettingsPopup(this)));
        pp.addButton(this.gui.i18nFormat("button.cpm.models", new Object[0]), () -> this.openPopup(new ModelsPopup(this)));
        pp.addButton(this.gui.i18nFormat("button.cpm.edit.controls", new Object[0]), () -> this.openPopup(KeybindsPopup.create(this)));
        pp.addButton(this.gui.i18nFormat("tab.cpm.social.errorLog", new Object[0]), () -> this.openPopup(new ErrorLogPopup(this)));
        pp.addButton(this.gui.i18nFormat("button.cpm.edit.pastes", new Object[0]), () -> new PastePopup(this).open());
        pp.addButton(this.gui.i18nFormat("label.cpm.wiki.title", new Object[0]), () -> this.openPopup(new WikiBrowserPopup(this.gui)));
        if (ModConfig.getCommonConfig().getBoolean("updateChecker", true)) {
            pp.addButton(this.gui.i18nFormat("label.cpm.changelog.title", new Object[0]), () -> this.openPopup(new ChangelogPopup(this.gui, null)));
        }
        MinecraftClientAccess.get().populatePlatformSettings("editPopup", pp);
    }

    private void initEffectMenu() {
        PopupMenu pp = new PopupMenu(this.gui, this);
        int x = this.topPanel.getX();
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.effect", new Object[0]), () -> pp.display(x, 20)));
        pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.effect.cubeEffects", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
        Checkbox boxGlow = pp.addCheckbox(this.gui.i18nFormat("label.cpm.glow", new Object[0]), () -> this.editor.switchEffect(Effect.GLOW));
        this.editor.setGlow.add(boxGlow::updateState);
        boxGlow.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.glow", new Object[0])));
        Checkbox boxSingleTex = pp.addCheckbox(this.gui.i18nFormat("label.cpm.singleTex", new Object[0]), () -> this.editor.switchEffect(Effect.SINGLE_TEX));
        this.editor.setSingleTex.add(boxSingleTex::updateState);
        boxSingleTex.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.singleTex", new Object[0])));
        Checkbox boxPfUV = pp.addCheckbox(this.gui.i18nFormat("label.cpm.perfaceUV", new Object[0]), () -> this.editor.switchEffect(Effect.PER_FACE_UV));
        this.editor.setPerFaceUV.add(boxPfUV::updateState);
        boxPfUV.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.perfaceUV", new Object[0])));
        Checkbox boxReColor = pp.addCheckbox(this.gui.i18nFormat("label.cpm.recolor", new Object[0]), () -> this.editor.switchEffect(Effect.RECOLOR));
        this.editor.setReColor.add(boxReColor::updateState);
        boxReColor.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.recolor", new Object[0])));
        ColorButton colorBtn = new ColorButton(this.gui, this, this.editor::setColor);
        this.editor.setPartColor.add(c -> {
            colorBtn.setEnabled(c != null);
            if (c != null) {
                colorBtn.setColor((int)c);
            } else {
                colorBtn.setColor(0);
            }
        });
        colorBtn.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.recolor.colorbtn", new Object[0])));
        pp.add(colorBtn);
        Checkbox boxHidden = pp.addCheckbox(this.gui.i18nFormat("label.cpm.hidden_effect", new Object[0]), () -> this.editor.switchEffect(Effect.HIDE));
        this.editor.setHiddenEffect.add(boxHidden::updateState);
        boxHidden.setTooltip(new Tooltip((Frame)this, this.gui.i18nFormat("tooltip.cpm.hidden_effect", new Object[0]), Keybinds.TOGGLE_HIDDEN_ACTION));
        Checkbox boxExtrude = pp.addCheckbox(this.gui.i18nFormat("label.cpm.extrude_effect", new Object[0]), () -> this.editor.switchEffect(Effect.EXTRUDE));
        this.editor.setExtrudeEffect.add(boxExtrude::updateState);
        boxExtrude.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.extrude_effect", new Object[0])));
        Checkbox boxCopyTransform = pp.addCheckbox(this.gui.i18nFormat("label.cpm.copyTransform", new Object[0]), () -> this.editor.switchEffect(Effect.COPY_TRANSFORM));
        this.editor.setCopyTransformEffect.add(boxCopyTransform::updateState);
        boxCopyTransform.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.copyTransform", new Object[0])));
        Checkbox boxDisableVanilla = pp.addCheckbox(this.gui.i18nFormat("label.cpm.disableVanillaAnim", new Object[0]), () -> this.editor.switchEffect(Effect.DISABLE_VANILLA_ANIM));
        this.editor.setDisableVanillaEffect.add(boxDisableVanilla::updateState);
        boxDisableVanilla.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.disableVanillaAnim", new Object[0])));
        pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.effect.modelEffects", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
        Checkbox chxbxScale = pp.addCheckbox(this.gui.i18nFormat("label.cpm.effect.scaling", new Object[0]), () -> {
            this.editor.action("switch", "label.cpm.effect.scaling").updateValueOp(this.editor, this.editor.scalingElem.enabled, !this.editor.scalingElem.enabled, (a, b) -> {
                a.scalingElem.enabled = b;
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> chxbxScale.setSelected(this.editor.scalingElem.enabled));
        chxbxScale.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.effect.scaling", new Object[0])));
        Checkbox hideHead = pp.addCheckbox(this.gui.i18nFormat("label.cpm.effect.hideHeadIfSkull", new Object[0]), () -> {
            this.editor.action("switch", "label.cpm.effect.hideHeadIfSkull").updateValueOp(this.editor, this.editor.hideHeadIfSkull, !this.editor.hideHeadIfSkull, (a, b) -> {
                a.hideHeadIfSkull = b;
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> hideHead.setSelected(this.editor.hideHeadIfSkull));
        hideHead.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.effect.hideHeadIfSkull", new Object[0])));
        Checkbox removeArmorOffset = pp.addCheckbox(this.gui.i18nFormat("label.cpm.effect.removeArmorOffset", new Object[0]), () -> {
            this.editor.action("switch", "label.cpm.effect.removeArmorOffset").updateValueOp(this.editor, this.editor.removeArmorOffset, !this.editor.removeArmorOffset, (a, b) -> {
                a.removeArmorOffset = b;
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> removeArmorOffset.setSelected(this.editor.removeArmorOffset));
        removeArmorOffset.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.effect.removeArmorOffset", new Object[0])));
        String fpText = this.gui.i18nFormat("tooltip.cpm.effect.setFpHandPos", new KeybindText("key.cpm.gestureMenu", "gestureMenu").toString(this.gui));
        Button fpHand = pp.addButton(this.gui.i18nFormat("button.cpm.effect.setFpHandPos", new Object[0]), new MessagePopup(this, this.gui.i18nFormat("label.cpm.info", new Object[0]), fpText));
        fpHand.setTooltip(new Tooltip(this, fpText));
        Checkbox removeBedOffset = pp.addCheckbox(this.gui.i18nFormat("label.cpm.effect.removeBedOffset", new Object[0]), () -> {
            this.editor.action("switch", "label.cpm.effect.removeBedOffset").updateValueOp(this.editor, this.editor.removeBedOffset, !this.editor.removeBedOffset, (a, b) -> {
                a.removeBedOffset = b;
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> removeBedOffset.setSelected(this.editor.removeBedOffset));
        removeBedOffset.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.effect.removeBedOffset", new Object[0])));
        Checkbox enableInvisGlow = pp.addCheckbox(this.gui.i18nFormat("label.cpm.effect.enableInvisGlow", new Object[0]), () -> {
            this.editor.action("switch", "label.cpm.effect.enableInvisGlow").updateValueOp(this.editor, this.editor.enableInvisGlow, !this.editor.enableInvisGlow, (a, b) -> {
                a.enableInvisGlow = b;
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> enableInvisGlow.setSelected(this.editor.enableInvisGlow));
        enableInvisGlow.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.effect.enableInvisGlow", new Object[0])));
        pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.effect.textureEffects", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
        Button btnAddAnimTex = pp.addButton(this.gui.i18nFormat("button.cpm.addAnimatedTex", new Object[0]), this.editor::addAnimTex);
        btnAddAnimTex.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.addAnimatedTex", new Object[0])));
        this.editor.setEnAddAnimTex.add(btnAddAnimTex::setEnabled);
        MinecraftClientAccess.get().populatePlatformSettings("effectsPopup", pp);
    }

    private void initDisplayMenu() {
        int x = this.topPanel.getX();
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.display", new Object[0]), () -> {
            PopupMenu pp = new PopupMenu(this.gui, this);
            this.editor.renderBase.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.drawBase", new Object[0]));
            if (this.viewType != ViewType.ANIMATION) {
                this.editor.playerTpose.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.player_tpose", new Object[0]));
            }
            this.editor.drawAllUVs.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.allUVs", new Object[0]));
            if (this.viewType == ViewType.TEXTURE) {
                Checkbox chxbxFilterDraw = this.editor.onlyDrawOnSelected.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.onlyDrawOnSelected", new Object[0]));
                chxbxFilterDraw.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.onlyDrawOnSelected", new Object[0])));
            }
            if (this.viewType == ViewType.ANIMATION) {
                Checkbox chxbxVanillaAnims = this.editor.playVanillaAnims.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.playVanillaAnims", new Object[0]));
                chxbxVanillaAnims.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.playVanillaAnims", new Object[0])));
            }
            Checkbox chxbxAnimatedTex = this.editor.playAnimatedTex.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.playAnimatedTex", new Object[0]));
            this.editor.playAnimatedTex.add(() -> {
                if (!this.editor.playAnimatedTex.get()) {
                    this.editor.textures.values().forEach(ETextures::refreshTexture);
                }
            });
            chxbxAnimatedTex.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.playAnimatedTex", new Object[0])));
            this.editor.drawBoundingBox.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.drawBoundingBox", new Object[0]));
            Checkbox chxbxChat = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.displayChat", new Object[0]), b -> {
                this.editor.displayChat = !b.isSelected();
                b.setSelected(this.editor.displayChat);
            });
            chxbxChat.setSelected(this.editor.displayChat);
            Checkbox chxbxAdvScaling = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.advScaling", new Object[0]), b -> {
                this.editor.displayAdvScaling = !b.isSelected();
                b.setSelected(this.editor.displayAdvScaling);
                this.editor.updateGui();
            });
            chxbxAdvScaling.setSelected(this.editor.displayAdvScaling);
            if (this.viewType == ViewType.ANIMATION) {
                Checkbox chxbxForceItemInAnim = this.editor.forceHeldItemInAnim.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.forceItemInAnim", new Object[0]));
                this.editor.forceHeldItemInAnim.add(this.editor::updateGui);
                chxbxForceItemInAnim.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.forceItemInAnim", new Object[0])));
            }
            Checkbox chxbxDisplayGizmo = this.editor.displayGizmo.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.displayGizmo", new Object[0]));
            this.editor.displayGizmo.add(this.editor::updateGui);
            chxbxDisplayGizmo.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.displayGizmo", Keybinds.TOGGLE_GIZMO.getSetKey(this.gui))));
            Checkbox chxbxShowOutlines = this.editor.showOutlines.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.showOutlines", new Object[0]));
            chxbxShowOutlines.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.showOutlines", new Object[0])));
            if (this.viewType == ViewType.ANIMATION) {
                Checkbox chxbxShowPreviousFrame = this.editor.showPreviousFrame.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.showPreviousFrame", new Object[0]));
                chxbxShowPreviousFrame.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.showPreviousFrame", new Object[0])));
            }
            if (this.viewType != ViewType.ANIMATION || this.editor.forceHeldItemInAnim.get()) {
                pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.display.items", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
                PopupMenu heldItemRight = new PopupMenu(this.gui, this);
                pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.heldItem.right", new Object[0]), heldItemRight);
                this.initHeldItemPopup(heldItemRight, ItemSlot.RIGHT_HAND);
                PopupMenu heldItemLeft = new PopupMenu(this.gui, this);
                pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.heldItem.left", new Object[0]), heldItemLeft);
                this.initHeldItemPopup(heldItemLeft, ItemSlot.LEFT_HAND);
                PopupMenu heldItemHead = new PopupMenu(this.gui, this);
                pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.heldItem.head", new Object[0]), heldItemHead);
                this.initHeldItemPopup(heldItemHead, ItemSlot.HEAD);
                pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.display.layers", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
                this.addLayerToggle(pp, PlayerModelLayer.CAPE);
                PopupMenu armor = new PopupMenu(this.gui, this);
                pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.armor", new Object[0]), armor);
                for (PlayerModelLayer a : PlayerModelLayer.ARMOR) {
                    this.addLayerToggle(armor, a);
                }
                armor.addButton(this.gui.i18nFormat("button.cpm.display.toggleArmor", new Object[0]), () -> {
                    if (Arrays.stream(PlayerModelLayer.ARMOR).noneMatch(r -> this.editor.modelDisplayLayers.stream().anyMatch(l -> l == r))) {
                        for (PlayerModelLayer a : PlayerModelLayer.ARMOR) {
                            this.editor.modelDisplayLayers.add(a);
                        }
                    } else {
                        for (PlayerModelLayer a : PlayerModelLayer.ARMOR) {
                            this.editor.modelDisplayLayers.remove((Object)a);
                        }
                    }
                    this.editor.updateGui();
                });
                this.addLayerToggle(pp, PlayerModelLayer.ELYTRA);
                this.editor.drawParrots.makeCheckbox(pp, this.gui.i18nFormat("label.cpm.display.drawParrots", new Object[0]));
            }
            MinecraftClientAccess.get().populatePlatformSettings("displayPopup", pp);
            pp.display(x, 20);
        }));
    }

    private void addLayerToggle(PopupMenu pp, PlayerModelLayer layer) {
        Checkbox chbx = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display." + layer.name().toLowerCase(Locale.ROOT), new Object[0]), c -> {
            if (!c.isSelected()) {
                this.editor.modelDisplayLayers.add(layer);
            } else {
                this.editor.modelDisplayLayers.remove((Object)layer);
            }
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> chbx.setSelected(this.editor.modelDisplayLayers.contains((Object)layer)));
        chbx.setSelected(this.editor.modelDisplayLayers.contains((Object)layer));
    }

    private void initHeldItemPopup(PopupMenu pp, ItemSlot hand) {
        ButtonGroup<DisplayItem, Checkbox> group = new ButtonGroup<DisplayItem, Checkbox>(Checkbox::setSelected, Checkbox::setAction, i -> this.editor.handDisplay.put(hand, (DisplayItem)((Object)i)));
        for (DisplayItem item : DisplayItem.VALUES) {
            if (hand == ItemSlot.HEAD && !item.canBeOnHead) continue;
            group.addElement(item, r -> pp.addCheckbox(this.gui.i18nFormat("button.cpm.heldItem." + item.name().toLowerCase(Locale.ROOT), new Object[0]), (Runnable)r));
        }
        group.accept(this.editor.handDisplay.getOrDefault((Object)hand, DisplayItem.NONE));
    }

    private void load(File file) {
        this.editor.load(file).handleAsync((v, e) -> {
            if (e != null) {
                Log.warn("Error loading project file", e);
                ErrorLog.addFormattedLog(ErrorLog.LogLevel.ERROR, "label.cpm.error.load", e, new Object[0]);
                this.showError("load", e.toString());
                this.editor.setInfoMsg.accept(Pair.of(0, ""));
                this.editor.loadDefaultPlayerModel();
                this.editor.updateGui();
            }
            EditorGui.addRecent(file);
            return null;
        }, this.gui::executeLater);
    }

    private void saveProject(File file) {
        this.editor.save(file).handleAsync((v, e) -> {
            if (e != null) {
                Log.warn("Error saving project file", e);
                ErrorLog.addFormattedLog(ErrorLog.LogLevel.ERROR, "label.cpm.error.save", e, new Object[0]);
                this.showError("save", e.toString());
                this.editor.setInfoMsg.accept(Pair.of(0, ""));
                return null;
            }
            if (TestIngameManager.isTesting() && TestIngameManager.openTestIngame(this, true)) {
                this.editor.setInfoMsg.accept(Pair.of(2000, this.gui.i18nFormat("tooltip.cpm.saveSuccess", file.getName()) + "\\" + this.gui.i18nFormat("label.cpm.test_model_exported", new Object[0])));
            }
            EditorGui.addRecent(file);
            return null;
        }, this.gui::executeLater);
    }

    public void loadSkin(File file) {
        ETextures tex = this.editor.getTextureProvider();
        if (tex != null) {
            ActionBuilder ab = this.editor.action("loadTexture");
            ab.updateValueOp(tex, tex.file, file, (a, b) -> {
                a.file = b;
            });
            this.editor.reloadSkin(ab, tex, file);
            this.editor.updateGui();
        }
    }

    private void showError(String msg, String error) {
        this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.error." + msg, new Object[0]), error));
    }

    public Editor getEditor() {
        return this.editor;
    }

    @Override
    public Box getMinBounds() {
        return new Box(0, 0, 500, 420);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        this.getKeybindHandler().registerKeybind(Keybinds.UNDO, this.editor::undo);
        this.getKeybindHandler().registerKeybind(Keybinds.REDO, this.editor::redo);
        this.getKeybindHandler().registerKeybind(Keybinds.SAVE, this::save);
        this.getKeybindHandler().registerKeybind(Keybinds.TOGGLE_GIZMO, this.editor.displayGizmo::toggle);
        this.getKeybindHandler().registerKeybind(Keybinds.RUN_QUICK_ACTION, () -> {
            if (this.editor.setQuickAction.get() != null) {
                this.editor.setQuickAction.get().runTask();
            }
        });
        this.getKeybindHandler().registerKeybind(Keybinds.FIND_ELEMENT, () -> {
            if (!this.hasPopupOpen()) {
                this.openPopup(new PartSearchPopup(this.gui, this.editor));
            }
        });
        this.getKeybindHandler().registerKeybind(Keybinds.RELOAD_TEXTURE, this.editor::reloadSkin);
        if (event.matches(this.gui.getKeyCodes().KEY_F5)) {
            this.editor.refreshCaches();
            event.consume();
        }
        super.keyPressed(event);
    }

    public static int getRotateMouseButton() {
        return ModConfig.getCommonConfig().getSetInt("editorRotateMouseButton", 2);
    }

    public static int getDragMouseButton() {
        return ModConfig.getCommonConfig().getSetInt("editorDragMouseButton", -1);
    }

    public static int getSelectMouseButton() {
        return ModConfig.getCommonConfig().getSetInt("editorSelectMouseButton", 0);
    }

    public static int getMenuMouseButton() {
        return ModConfig.getCommonConfig().getSetInt("editorMenuMouseButton", 1);
    }

    public static boolean doOpenEditor() {
        return toReopen != null;
    }

    @Override
    public void tick() {
        this.editor.tick();
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        if (this.tooltipTime > System.currentTimeMillis() && this.msgTooltip != null) {
            this.msgTooltip.set();
        }
        super.draw(event, partialTicks);
    }

    @Override
    public void logMessage(String msg) {
        this.editor.setInfoMsg.accept(Pair.of(3000, this.gui.i18nFormat("tooltip.cpm.errorTooltip", msg)));
    }

    @Override
    public boolean enableChat() {
        return this.editor.displayChat;
    }

    public static Editor getActiveTestingEditor() {
        return toReopen;
    }

    @Override
    protected void onClosing() {
        if (ModConfig.getCommonConfig().getBoolean("editorEscExit", true)) {
            this.gui.closeGui();
        }
    }

    @Override
    public void onCrashed(String msg, Throwable e) {
        try {
            this.editor.saveRecovered();
        }
        catch (Throwable ex) {
            e.addSuppressed(ex);
        }
        try {
            this.editor.free();
        }
        catch (Throwable ex) {
            e.addSuppressed(ex);
        }
    }

    static {
        smallGuiWarning = true;
        notSupportedWarning = true;
        ConfigEntry.ConfigEntryList ce = ModConfig.getCommonConfig().getEntryList("editorRecentProjects");
        for (int i = 0; i < ce.size(); ++i) {
            String o = String.valueOf(ce.get(i));
            File f = new File(o);
            if (!f.exists()) continue;
            recent.add(f);
        }
        String last = ModConfig.getCommonConfig().getString("editorLastVersion", null);
        if (last == null) {
            showFirstStart = true;
        } else if (!MinecraftObjectHolder.DEBUGGING && ModConfig.getCommonConfig().getBoolean("updateChecker", true)) {
            ComparableVersion l = new ComparableVersion(last);
            ComparableVersion c = new ComparableVersion(MinecraftCommonAccess.get().getModVersion());
            if (c.compareTo(l) > 0) {
                showChangelog = last;
            } else {
                showNewVersionPopup = MinecraftCommonAccess.get().getVersionCheck().isOutdated();
            }
        }
        ModConfig.getCommonConfig().setString("editorLastVersion", MinecraftCommonAccess.get().getModVersion());
        ModConfig.getCommonConfig().save();
    }

    public static enum ViewType {
        MODEL,
        TEXTURE,
        ANIMATION;

    }
}

