/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.builtin;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.builtin.VanillaPlayerModel;
import com.tom.cpm.shared.model.render.BoxRender;
import com.tom.cpm.shared.model.render.Mesh;
import com.tom.cpm.shared.model.render.VanillaModelPart;

public class VanillaPartRenderer {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    protected PartValues val;
    protected Mesh renderer;

    public VanillaPartRenderer(VanillaPlayerModel model, VanillaModelPart part, SkinType type, int tw, int th) {
        this.val = part.getDefaultSize(type);
        this.x = this.val.getPos().x;
        this.y = this.val.getPos().y;
        this.z = this.val.getPos().z;
        this.renderer = BoxRender.createTextured(this.val.getOffset(), this.val.getSize(), new Vec3f(1.0f, 1.0f, 1.0f), this.val.getMCScale(), this.val.getUV().x, this.val.getUV().y, this.val.isMirror() ? -1 : 1, tw, th);
        model.parts.add(this);
    }

    public VanillaPartRenderer() {
    }

    public void render(MatrixStack stack, VertexBuffer buf) {
        stack.push();
        this.translateRotatePart(stack);
        this.renderer.draw(stack, buf, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.pop();
    }

    public void translateRotatePart(MatrixStack matrixStackIn) {
        matrixStackIn.translate(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
        if (this.zRot != 0.0f) {
            matrixStackIn.rotate(Vec3f.POSITIVE_Z.getRadialQuaternion(this.zRot));
        }
        if (this.yRot != 0.0f) {
            matrixStackIn.rotate(Vec3f.POSITIVE_Y.getRadialQuaternion(this.yRot));
        }
        if (this.xRot != 0.0f) {
            matrixStackIn.rotate(Vec3f.POSITIVE_X.getRadialQuaternion(this.xRot));
        }
    }

    public void reset() {
        this.x = this.val.getPos().x;
        this.y = this.val.getPos().y;
        this.z = this.val.getPos().z;
        this.xRot = 0.0f;
        this.yRot = 0.0f;
        this.zRot = 0.0f;
        this.visible = true;
    }

    public void copyFrom(VanillaPartRenderer from) {
        this.xRot = from.xRot;
        this.yRot = from.yRot;
        this.zRot = from.zRot;
        this.x = from.x;
        this.y = from.y;
        this.z = from.z;
    }
}

